/*
 * Decompiled with CFR 0.152.
 */
package org.destinationsol.game.item;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.TextureAtlas;
import org.destinationsol.game.SolGame;
import org.destinationsol.game.item.SolItem;
import org.destinationsol.game.item.SolItemType;
import org.destinationsol.game.ship.hulls.HullConfig;

public class ShipItem
implements SolItem {
    public static final SolItemType EMPTY = new SolItemType(new Color(), null, 1.0f);
    private final HullConfig config;
    private final String description;

    ShipItem(HullConfig config) {
        this.config = config;
        this.description = ShipItem.makeDesc(config);
    }

    public static String makeDesc(HullConfig hull) {
        boolean secondGunSlot;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Takes ").append(hull.getMaxLife()).append(" dmg\n");
        boolean bl = secondGunSlot = hull.getNrOfGunSlots() > 1;
        if (!secondGunSlot || hull.getGunSlot(0).allowsRotation() != hull.getGunSlot(1).allowsRotation()) {
            if (!secondGunSlot) {
                stringBuilder.append(!hull.getGunSlot(0).allowsRotation() ? "1 heavy gun slot\n" : "1 light gun slot\n");
            } else {
                stringBuilder.append("1 heavy + 1 light gun slots\n");
            }
        } else {
            stringBuilder.append(!hull.getGunSlot(0).allowsRotation() ? "2 heavy gun slots\n" : "2 light gun slots\n");
        }
        if (hull.getAbility() != null) {
            stringBuilder.append("Ability:\n");
            hull.getAbility().appendDesc(stringBuilder);
        }
        return stringBuilder.toString();
    }

    @Override
    public String getDisplayName() {
        return this.config.getDisplayName();
    }

    @Override
    public float getPrice() {
        return this.config.getPrice();
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public SolItem copy() {
        return new ShipItem(this.config);
    }

    @Override
    public boolean isSame(SolItem item) {
        return item instanceof ShipItem && ((ShipItem)item).config == this.config;
    }

    @Override
    public TextureAtlas.AtlasRegion getIcon(SolGame game) {
        return this.config.getIcon();
    }

    @Override
    public SolItemType getItemType() {
        return EMPTY;
    }

    @Override
    public String getCode() {
        return null;
    }

    @Override
    public int isEquipped() {
        return 0;
    }

    @Override
    public void setEquipped(int equipped) {
    }

    public HullConfig getConfig() {
        return this.config;
    }
}

