/*
 * Decompiled with CFR 0.152.
 */
package org.destinationsol.game.item;

import com.badlogic.gdx.graphics.Color;
import org.destinationsol.assets.json.Validator;
import org.destinationsol.assets.sound.OggSound;
import org.destinationsol.assets.sound.OggSoundManager;
import org.destinationsol.game.GameColors;
import org.destinationsol.game.item.SolItemType;
import org.json.JSONObject;

public class SolItemTypes {
    public final SolItemType clip;
    public final SolItemType shield;
    public final SolItemType armor;
    public final SolItemType abilityCharge;
    public final SolItemType gun;
    public final SolItemType money;
    public final SolItemType medMoney;
    public final SolItemType bigMoney;
    public final SolItemType repair;
    public final SolItemType fixedGun;

    public SolItemTypes(OggSoundManager soundManager, GameColors cols) {
        JSONObject rootNode = Validator.getValidatedJSON("core:types", "engine:schemaTypes");
        this.clip = this.load(rootNode.getJSONObject("clip"), soundManager, cols);
        this.shield = this.load(rootNode.getJSONObject("shield"), soundManager, cols);
        this.armor = this.load(rootNode.getJSONObject("armor"), soundManager, cols);
        this.abilityCharge = this.load(rootNode.getJSONObject("abilityCharge"), soundManager, cols);
        this.gun = this.load(rootNode.getJSONObject("gun"), soundManager, cols);
        this.fixedGun = this.load(rootNode.getJSONObject("fixedGun"), soundManager, cols);
        this.money = this.load(rootNode.getJSONObject("money"), soundManager, cols);
        this.medMoney = this.load(rootNode.getJSONObject("medMoney"), soundManager, cols);
        this.bigMoney = this.load(rootNode.getJSONObject("bigMoney"), soundManager, cols);
        this.repair = this.load(rootNode.getJSONObject("repair"), soundManager, cols);
    }

    private SolItemType load(JSONObject itemNode, OggSoundManager soundManager, GameColors cols) {
        Color color = cols.load(itemNode.getString("color"));
        OggSound pickUpSound = soundManager.getSound(itemNode.getString("pickUpSound"));
        float sz = (float)itemNode.getDouble("sz");
        return new SolItemType(color, pickUpSound, sz);
    }
}

