/*
 * Decompiled with CFR 0.152.
 */
package org.destinationsol.game.item;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.destinationsol.files.HullConfigManager;
import org.destinationsol.game.ShipConfig;
import org.destinationsol.game.item.ItemConfig;
import org.destinationsol.game.item.ItemContainer;
import org.destinationsol.game.item.ItemManager;
import org.destinationsol.game.item.MercItem;
import org.destinationsol.game.item.ShipItem;
import org.destinationsol.game.ship.hulls.HullConfig;
import org.json.JSONObject;

public class TradeConfig {
    public final List<ItemConfig> items = new ArrayList<ItemConfig>();
    public final ItemContainer hulls = new ItemContainer();
    public final ItemContainer mercs = new ItemContainer();

    public void load(JSONObject tradeNode, HullConfigManager hullConfigs, ItemManager itemManager) {
        if (tradeNode == null) {
            return;
        }
        String itemStr = tradeNode.getString("items");
        List<ItemConfig> itemList = itemManager.parseItems(itemStr);
        Collections.reverse(itemList);
        this.items.addAll(itemList);
        String shipStr = tradeNode.optString("ships", "");
        String[] split = shipStr.split(" ");
        for (int i = split.length - 1; i >= 0; --i) {
            String hullName = split[i];
            HullConfig hull = hullConfigs.getConfig(hullName);
            this.hulls.add(new ShipItem(hull));
        }
        ArrayList<ShipConfig> loadList = ShipConfig.loadList(tradeNode.getJSONArray("mercenaries"), hullConfigs, itemManager);
        for (int i = loadList.size() - 1; i >= 0; --i) {
            ShipConfig merc = loadList.get(i);
            this.mercs.add(new MercItem(merc));
        }
    }
}

