/*
 * Decompiled with CFR 0.152.
 */
package org.destinationsol.game.item;

import java.util.List;
import org.destinationsol.game.SolGame;
import org.destinationsol.game.item.ItemConfig;
import org.destinationsol.game.item.ItemContainer;
import org.destinationsol.game.item.SolItem;
import org.destinationsol.game.item.TradeConfig;

public class TradeContainer {
    private static final float MAX_AWAIT = 180.0f;
    private final TradeConfig config;
    private final ItemContainer myItems;
    private float myAwait;

    public TradeContainer(TradeConfig config) {
        this.config = config;
        this.myItems = new ItemContainer();
    }

    public void update(SolGame game) {
        if (0.0f < this.myAwait) {
            this.myAwait -= game.getTimeStep();
            return;
        }
        this.myAwait = 180.0f;
        this.myItems.clear();
        List<ItemConfig> items = this.config.items;
        for (ItemConfig i : items) {
            SolItem ex = i.examples.get(0);
            int amt = ex.isSame(ex) ? 16 : 1;
            for (int j = 0; j < amt; ++j) {
                if (!this.myItems.canAdd(ex)) continue;
                this.myItems.add(ex.copy());
            }
        }
    }

    public ItemContainer getItems() {
        return this.myItems;
    }

    public ItemContainer getShips() {
        return this.config.hulls;
    }

    public ItemContainer getMercs() {
        return this.config.mercs;
    }
}

