/*
 * Decompiled with CFR 0.152.
 */
package org.destinationsol.game.maze;

import com.badlogic.gdx.math.Vector2;
import org.destinationsol.game.HardnessCalc;
import org.destinationsol.game.SolCam;
import org.destinationsol.game.SolGame;
import org.destinationsol.game.maze.MazeBuilder;
import org.destinationsol.game.maze.MazeConfig;

public class Maze {
    private final MazeConfig config;
    private final Vector2 position;
    private final float radius;
    private final float damagePerSecond;
    private boolean areObjectsCreated;

    public Maze(MazeConfig config, Vector2 position, float radius) {
        this.config = config;
        this.position = position;
        this.radius = radius;
        this.damagePerSecond = HardnessCalc.getMazeDps(config);
    }

    public void update(SolGame game) {
        SolCam cam = game.getCam();
        Vector2 camPos = cam.getPosition();
        if (!this.areObjectsCreated && camPos.dst(this.position) < this.radius + 17.2f) {
            new MazeBuilder().build(game, this);
            this.areObjectsCreated = true;
        }
    }

    public MazeConfig getConfig() {
        return this.config;
    }

    public Vector2 getPos() {
        return this.position;
    }

    public float getRadius() {
        return this.radius;
    }

    public float getDps() {
        return this.damagePerSecond;
    }
}

