/*
 * Decompiled with CFR 0.152.
 */
package org.destinationsol.game.maze;

import com.badlogic.gdx.math.Vector2;
import java.util.ArrayList;
import org.destinationsol.common.SolMath;
import org.destinationsol.common.SolRandom;
import org.destinationsol.game.Faction;
import org.destinationsol.game.ShipConfig;
import org.destinationsol.game.SolGame;
import org.destinationsol.game.input.AiPilot;
import org.destinationsol.game.input.StillGuard;
import org.destinationsol.game.maze.Maze;
import org.destinationsol.game.maze.MazeConfig;
import org.destinationsol.game.maze.MazeLayout;
import org.destinationsol.game.maze.MazeLayoutBuilder;
import org.destinationsol.game.maze.MazeTile;
import org.destinationsol.game.maze.MazeTileObject;
import org.destinationsol.game.ship.FarShip;
import org.destinationsol.game.ship.ShipBuilder;

public class MazeBuilder {
    public static final float BORDER = 4.0f;
    public static final float TILE_SZ = 3.5f;
    private int size;
    private Vector2 mazePosition;
    private float mazeAngle;
    private float innerRadius;

    public void build(SolGame game, Maze maze) {
        this.innerRadius = maze.getRadius() - 4.0f;
        this.size = (int)(this.innerRadius * 2.0f / 3.5f);
        this.mazePosition = maze.getPos();
        this.mazeAngle = SolRandom.seededRandomFloat(180.0f);
        MazeLayout layout = this.buildMaze(game, maze);
        this.buildEnemies(game, maze, layout);
    }

    private MazeLayout buildMaze(SolGame game, Maze maze) {
        MazeLayout layout = new MazeLayoutBuilder(this.size).build();
        new MazeTileObject.Builder();
        MazeConfig config = maze.getConfig();
        for (int col = 0; col < this.size; ++col) {
            for (int row = 0; row < this.size; ++row) {
                boolean dInner;
                boolean rInner;
                boolean ulInner = col > 0 && row > 0 && layout.inners[col][row];
                boolean bl = rInner = row > 0 && col < this.size - 1 && layout.inners[col + 1][row];
                if (row > 0 && (ulInner || rInner)) {
                    boolean wall = layout.right[col][row];
                    boolean inner = ulInner && rInner;
                    float tileAngle = this.mazeAngle - 90.0f;
                    if (!ulInner) {
                        tileAngle += 180.0f;
                    }
                    Vector2 tilePos = this.cellPos(col, row, 1.75f, 0.0f);
                    ArrayList<MazeTile> tiles = wall ? (inner ? config.innerWalls : config.borderWalls) : (inner ? config.innerPasses : config.borderPasses);
                    MazeTile tile = SolRandom.seededRandomElement(tiles);
                    MazeTileObject.MyFar mto = new MazeTileObject.MyFar(tile, tileAngle, new Vector2(tilePos), SolRandom.test(0.5f));
                    game.getObjectManager().addFarObjNow(mto);
                }
                boolean bl2 = dInner = col > 0 && row < this.size - 1 && layout.inners[col][row + 1];
                if (col <= 0 || !ulInner && !dInner) continue;
                boolean wall = layout.down[col][row];
                boolean inner = ulInner && dInner;
                float tileAngle = this.mazeAngle;
                if (!ulInner) {
                    tileAngle += 180.0f;
                }
                Vector2 tilePos = this.cellPos(col, row, 0.0f, 1.75f);
                ArrayList<MazeTile> tiles = wall ? (inner ? config.innerWalls : config.borderWalls) : (inner ? config.innerPasses : config.borderPasses);
                MazeTile tile = SolRandom.seededRandomElement(tiles);
                MazeTileObject.MyFar mto = new MazeTileObject.MyFar(tile, tileAngle, new Vector2(tilePos), SolRandom.test(0.5f));
                game.getObjectManager().addFarObjNow(mto);
            }
        }
        return layout;
    }

    private Vector2 cellPos(int col, int row, float xOffset, float yOffset) {
        Vector2 res = new Vector2((float)(col - this.size / 2) * 3.5f + xOffset, (float)(row - this.size / 2) * 3.5f + yOffset);
        SolMath.rotate(res, this.mazeAngle);
        res.add(this.mazePosition);
        return res;
    }

    private void buildEnemies(SolGame game, Maze maze, MazeLayout layout) {
        MazeConfig config = maze.getConfig();
        float dist = maze.getRadius() - 2.0f;
        float circleLen = dist * (float)Math.PI * 2.0f;
        for (ShipConfig shipConfig : config.outerEnemies) {
            int count = (int)(shipConfig.density * circleLen);
            for (int i = 0; i < count; ++i) {
                Vector2 position = new Vector2();
                SolMath.fromAl(position, SolRandom.randomFloat(180.0f), dist);
                position.add(this.mazePosition);
                this.buildEnemy(position, game, shipConfig, false);
            }
        }
        boolean[][] occupiedCells = new boolean[this.size][this.size];
        occupiedCells[this.size / 2][this.size / 2] = true;
        for (ShipConfig e : config.innerEnemies) {
            int count = (int)(e.density * this.innerRadius * this.innerRadius * (float)Math.PI);
            for (int i = 0; i < count; ++i) {
                Vector2 position = this.getFreeCellPos(occupiedCells);
                if (position == null) continue;
                this.buildEnemy(position, game, e, true);
            }
        }
        ShipConfig shipConfig = SolRandom.randomElement(config.bosses);
        Vector2 position = this.cellPos(this.size / 2, this.size / 2, 0.0f, 0.0f);
        this.buildEnemy(position, game, shipConfig, true);
    }

    private Vector2 getFreeCellPos(boolean[][] occupiedCells) {
        for (int i = 0; i < 10; ++i) {
            Vector2 position;
            int row;
            int col = SolRandom.seededRandomInt(this.size);
            if (occupiedCells[col][row = SolRandom.seededRandomInt(this.size)] || 0.8f * this.innerRadius < (position = this.cellPos(col, row, 0.0f, 0.0f)).dst(this.mazePosition)) continue;
            occupiedCells[col][row] = true;
            return position;
        }
        return null;
    }

    private void buildEnemy(Vector2 position, SolGame game, ShipConfig e, boolean inner) {
        float angle = SolRandom.randomFloat(180.0f);
        ShipBuilder sb = game.getShipBuilder();
        float viewDist = 5.4f;
        if (inner) {
            viewDist = 4.375f;
        }
        AiPilot pilot = new AiPilot(new StillGuard(position, game, e), false, Faction.EHAR, true, null, viewDist);
        int money = e.money;
        FarShip s = sb.buildNewFar(game, position, new Vector2(), angle, 0.0f, pilot, e.items, e.hull, null, false, money, null, true);
        game.getObjectManager().addFarObjNow(s);
    }
}

