/*
 * Decompiled with CFR 0.152.
 */
package org.destinationsol.game.maze;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.destinationsol.assets.Assets;
import org.destinationsol.assets.json.Json;
import org.destinationsol.assets.json.Validator;
import org.destinationsol.files.HullConfigManager;
import org.destinationsol.game.item.ItemManager;
import org.destinationsol.game.maze.MazeConfig;
import org.json.JSONObject;
import org.terasology.gestalt.assets.ResourceUrn;

public class MazeConfigs {
    public final List<MazeConfig> configs = new ArrayList<MazeConfig>();

    public MazeConfigs(HullConfigManager hullConfigs, ItemManager itemManager) {
        Set<ResourceUrn> configUrns = Assets.getAssetHelper().listAssets(Json.class, "mazesConfig");
        for (ResourceUrn configUrn : configUrns) {
            JSONObject rootNode = Validator.getValidatedJSON(configUrn.toString(), "engine:schemaMazesConfig");
            for (String s : rootNode.keySet()) {
                if (!(rootNode.get(s) instanceof JSONObject)) continue;
                JSONObject mazeNode = rootNode.getJSONObject(s);
                MazeConfig c = MazeConfig.load(s, mazeNode, hullConfigs, itemManager);
                this.configs.add(c);
            }
        }
    }
}

