/*
 * Decompiled with CFR 0.152.
 */
package org.destinationsol.game.maze;

import org.destinationsol.common.SolMath;
import org.destinationsol.common.SolRandom;
import org.destinationsol.game.maze.MazeLayout;

public class MazeLayoutBuilder {
    private static final float HOLE_PERCENTAGE = 0.2f;
    private static final float WALL_PERCENTAGE = 0.5f;
    private final int size;
    private final boolean[][] inners;
    private final boolean[][] holes;
    private final boolean[][] right;
    private final boolean[][] down;

    MazeLayoutBuilder(int size) {
        this.size = size;
        this.inners = new boolean[size][size];
        this.holes = new boolean[size][size];
        this.right = new boolean[size][size];
        this.down = new boolean[size][size];
    }

    public MazeLayout build() {
        this.setInners();
        for (int col = 0; col < this.size; ++col) {
            for (int row = 0; row < this.size; ++row) {
                boolean inner = this.inners[col][row];
                boolean rInner = col < this.size - 1 && this.inners[col + 1][row];
                boolean dInner = row < this.size - 1 && this.inners[col][row + 1];
                this.right[col][row] = (inner || rInner) && SolRandom.test(0.5f);
                this.down[col][row] = (inner || dInner) && SolRandom.test(0.5f);
            }
        }
        this.makeAllAccessible();
        return new MazeLayout(this.inners, this.holes, this.right, this.down);
    }

    private void makeAllAccessible() {
        int[][] steps = new int[this.size][this.size];
        this.expandPath(steps, 0, 0, 0);
        for (int col = 0; col < this.size; ++col) {
            for (int row = 0; row < this.size; ++row) {
                int step;
                if (steps[col][row] != 0) continue;
                int lStep = 0;
                if (col > 0) {
                    lStep = steps[col - 1][row];
                }
                int uStep = 0;
                if (row > 0) {
                    uStep = steps[col][row - 1];
                }
                if (lStep < uStep) {
                    this.down[col][row - 1] = false;
                    step = uStep;
                } else {
                    this.right[col - 1][row] = false;
                    step = lStep;
                }
                this.expandPath(steps, col, row, step);
            }
        }
    }

    private void expandPath(int[][] steps, int col, int row, int prevStep) {
        int step;
        if (steps[col][row] > 0) {
            return;
        }
        steps[col][row] = step = prevStep + 1;
        if (col > 0 && !this.right[col - 1][row]) {
            this.expandPath(steps, col - 1, row, step);
        }
        if (row > 0 && !this.down[col][row - 1]) {
            this.expandPath(steps, col, row - 1, step);
        }
        if (col < this.size - 1 && !this.right[col][row]) {
            this.expandPath(steps, col + 1, row, step);
        }
        if (row < this.size - 1 && !this.down[col][row]) {
            this.expandPath(steps, col, row + 1, step);
        }
    }

    private void setInners() {
        float[][] values = new float[this.size][this.size];
        for (int i = 0; i < this.size; ++i) {
            for (int j = 0; j < this.size; ++j) {
                values[i][j] = SolRandom.seededRandomFloat(0.0f, 1.0f);
            }
        }
        this.smooth(values);
        this.smooth(values);
        float min = 1.0f;
        float max = 0.0f;
        for (int i = 0; i < this.size; ++i) {
            for (int j = 0; j < this.size; ++j) {
                float value = values[i][j];
                if (max < value) {
                    max = value;
                }
                if (!(value < min)) continue;
                min = value;
            }
        }
        float multiplier = 1.0f / (max - min);
        for (int i = 0; i < this.size; ++i) {
            for (int j = 0; j < this.size; ++j) {
                values[i][j] = multiplier * (values[i][j] - min);
            }
        }
        int value1 = 0;
        int value2 = 0;
        int value3 = 0;
        float chance1 = 0.15f;
        float chance2 = 0.2f;
        float chance3 = 0.25f;
        for (int i = 0; i < this.size; ++i) {
            for (int j = 0; j < this.size; ++j) {
                if (values[i][j] < chance1) {
                    ++value1;
                }
                if (values[i][j] < chance2) {
                    ++value2;
                }
                if (!(values[i][j] < chance3)) continue;
                ++value3;
            }
        }
        float p1 = 1.0f * (float)value1 / (float)this.size / (float)this.size;
        float p2 = 1.0f * (float)value2 / (float)this.size / (float)this.size;
        float p3 = 1.0f * (float)value3 / (float)this.size / (float)this.size;
        p1 = SolMath.abs(p1 - 0.2f);
        p2 = SolMath.abs(p2 - 0.2f);
        p3 = SolMath.abs(p3 - 0.2f);
        float cutoff = p1 < p2 ? (p1 < p3 ? chance1 : chance3) : (p2 < p3 ? chance2 : chance3);
        for (int i = 0; i < this.size; ++i) {
            for (int j = 0; j < this.size; ++j) {
                if (!this.isOk(i, j) || !(cutoff < values[i][j])) continue;
                this.inners[i][j] = true;
            }
        }
    }

    private void smooth(float[][] vals) {
        for (int col = 0; col < this.size; ++col) {
            for (int row = 0; row < this.size; ++row) {
                float v = vals[col][row];
                float lv = col == 0 ? 1.0f : vals[col - 1][row];
                float rv = col == this.size - 1 ? 1.0f : vals[col + 1][row];
                float uv = row == 0 ? 1.0f : vals[col][row - 1];
                float dv = row == this.size - 1 ? 1.0f : vals[col][row + 1];
                vals[col][row] = (v + lv + rv + uv + dv) / 5.0f;
            }
        }
    }

    private boolean isOk(int i, int j) {
        int ii = i - this.size / 2;
        int jj = j - this.size / 2;
        float dist = SolMath.sqrt(ii * ii + jj * jj);
        return dist < (float)(this.size / 2);
    }
}

