/*
 * Decompiled with CFR 0.152.
 */
package org.destinationsol.game.maze;

import com.badlogic.gdx.graphics.g2d.TextureAtlas;
import com.badlogic.gdx.math.Vector2;
import java.util.ArrayList;
import java.util.List;
import org.destinationsol.game.CollisionMeshLoader;
import org.destinationsol.game.DebugOptions;

public class MazeTile {
    public final TextureAtlas.AtlasRegion tex;
    public final List<List<Vector2>> points;
    public final boolean metal;
    public final TextureAtlas.AtlasRegion backgroundTexture;

    public MazeTile(TextureAtlas.AtlasRegion tex, List<List<Vector2>> points, boolean metal, TextureAtlas.AtlasRegion backgroundTexture) {
        this.tex = tex;
        this.points = points;
        this.metal = metal;
        this.backgroundTexture = backgroundTexture;
    }

    public static MazeTile load(TextureAtlas.AtlasRegion tex, CollisionMeshLoader.RigidBodyModel tilePaths, boolean wall, boolean metal, TextureAtlas.AtlasRegion backgroundTexture) {
        ArrayList<List<Vector2>> points = new ArrayList<List<Vector2>>();
        List<Object> shapes = tilePaths == null ? new ArrayList() : tilePaths.polygons;
        for (CollisionMeshLoader.PolygonModel polygonModel : shapes) {
            ArrayList<Vector2> vertices = new ArrayList<Vector2>(polygonModel.vertices);
            points.add(vertices);
        }
        if (points.isEmpty() && wall) {
            DebugOptions.MISSING_PHYSICS_ACTION.handle("found no paths for " + tex.name);
            ArrayList<Vector2> wallPoints = new ArrayList<Vector2>();
            wallPoints.add(new Vector2(0.0f, 0.4f));
            wallPoints.add(new Vector2(1.0f, 0.45f));
            wallPoints.add(new Vector2(1.0f, 0.55f));
            wallPoints.add(new Vector2(0.0f, 0.6f));
            points.add(wallPoints);
        }
        return new MazeTile(tex, points, metal, backgroundTexture);
    }
}

