/*
 * Decompiled with CFR 0.152.
 */
package org.destinationsol.game.maze;

import com.badlogic.gdx.graphics.g2d.TextureAtlas;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.physics.box2d.Body;
import com.badlogic.gdx.physics.box2d.BodyDef;
import com.badlogic.gdx.physics.box2d.ChainShape;
import com.badlogic.gdx.physics.box2d.Fixture;
import com.badlogic.gdx.physics.box2d.Shape;
import java.util.ArrayList;
import java.util.List;
import org.destinationsol.common.SolColor;
import org.destinationsol.game.DmgType;
import org.destinationsol.game.FarObject;
import org.destinationsol.game.SolGame;
import org.destinationsol.game.SolObject;
import org.destinationsol.game.drawables.Drawable;
import org.destinationsol.game.drawables.DrawableLevel;
import org.destinationsol.game.drawables.RectSprite;
import org.destinationsol.game.drawables.SpriteManager;
import org.destinationsol.game.maze.MazeTile;

public class MazeTileObject
implements SolObject {
    private final List<Drawable> drawables;
    private final Body body;
    private final Vector2 position;
    private final float angle;
    private final MazeTile tile;
    private final boolean isFlipped;

    public MazeTileObject(MazeTile tile, List<Drawable> drawables, Body body, Vector2 position, float angle, boolean flipped) {
        this.tile = tile;
        this.drawables = drawables;
        this.body = body;
        this.position = position;
        this.angle = angle;
        this.isFlipped = flipped;
    }

    @Override
    public void update(SolGame game) {
    }

    @Override
    public boolean shouldBeRemoved(SolGame game) {
        return false;
    }

    @Override
    public void onRemove(SolGame game) {
        if (this.body != null) {
            this.body.getWorld().destroyBody(this.body);
        }
    }

    @Override
    public void receiveDmg(float dmg, SolGame game, Vector2 position, DmgType dmgType) {
        game.getSpecialSounds().playHit(game, this, position, dmgType);
    }

    @Override
    public boolean receivesGravity() {
        return false;
    }

    @Override
    public void receiveForce(Vector2 force, SolGame game, boolean acc) {
    }

    @Override
    public Vector2 getPosition() {
        return this.position;
    }

    @Override
    public FarObject toFarObject() {
        return new MyFar(this.tile, this.angle, this.position, this.isFlipped);
    }

    @Override
    public List<Drawable> getDrawables() {
        return this.drawables;
    }

    @Override
    public float getAngle() {
        return this.angle;
    }

    @Override
    public Vector2 getVelocity() {
        return null;
    }

    @Override
    public void handleContact(SolObject other, float absImpulse, SolGame game, Vector2 collPos) {
    }

    @Override
    public String toDebugString() {
        return null;
    }

    @Override
    public Boolean isMetal() {
        return this.tile.metal;
    }

    @Override
    public boolean hasBody() {
        return true;
    }

    public static class MyFar
    implements FarObject {
        private final MazeTile tile;
        private final float angle;
        private final Vector2 position;
        private final boolean isFlipped;

        public MyFar(MazeTile tile, float angle, Vector2 position, boolean flipped) {
            this.tile = tile;
            this.angle = angle;
            this.position = position;
            this.isFlipped = flipped;
        }

        @Override
        public boolean shouldBeRemoved(SolGame game) {
            return false;
        }

        @Override
        public SolObject toObject(SolGame game) {
            return new Builder().build(game, this.tile, this.position, this.angle, this.isFlipped);
        }

        @Override
        public void update(SolGame game) {
        }

        @Override
        public float getRadius() {
            return 1.75f;
        }

        @Override
        public Vector2 getPosition() {
            return this.position;
        }

        @Override
        public String toDebugString() {
            return null;
        }

        @Override
        public boolean hasBody() {
            return true;
        }
    }

    public static class Builder {
        public MazeTileObject build(SolGame game, MazeTile tile, Vector2 position, float angle, boolean flipped) {
            ArrayList<Drawable> drawables = new ArrayList<Drawable>();
            TextureAtlas.AtlasRegion tex = new TextureAtlas.AtlasRegion(tile.tex);
            TextureAtlas.AtlasRegion backgroundTexture = new TextureAtlas.AtlasRegion(tile.backgroundTexture);
            if (flipped) {
                tex.flip(!tex.isFlipX(), !tex.isFlipY());
                backgroundTexture.flip(!backgroundTexture.isFlipX(), !backgroundTexture.isFlipY());
            }
            RectSprite s = SpriteManager.createSprite(tex.name, 3.5f, 0.0f, 0.0f, new Vector2(), DrawableLevel.GROUND, 0.0f, 0.0f, SolColor.WHITE, false);
            drawables.add(s);
            RectSprite s2 = SpriteManager.createSprite(backgroundTexture.name, 3.5f, 0.0f, 0.0f, new Vector2(), DrawableLevel.DECO, 0.0f, 0.0f, SolColor.WHITE, false);
            drawables.add(s2);
            Body body = this.buildBody(game, angle, position, tile, flipped);
            MazeTileObject res = new MazeTileObject(tile, drawables, body, position, angle, flipped);
            body.setUserData((Object)res);
            return res;
        }

        private Body buildBody(SolGame game, float angle, Vector2 position, MazeTile tile, boolean flipped) {
            BodyDef def = new BodyDef();
            def.type = BodyDef.BodyType.KinematicBody;
            def.position.set(position);
            def.angle = angle * ((float)Math.PI / 180);
            def.angularDamping = 0.0f;
            Body body = game.getObjectManager().getWorld().createBody(def);
            for (List<Vector2> pts : tile.points) {
                ChainShape shape = new ChainShape();
                ArrayList<Vector2> points = new ArrayList<Vector2>();
                int sz = pts.size();
                for (int i = 0; i < sz; ++i) {
                    Vector2 curr = pts.get(flipped ? sz - i - 1 : i);
                    Vector2 v = new Vector2(curr);
                    v.add(-0.5f, -0.5f);
                    if (flipped) {
                        v.x *= -1.0f;
                    }
                    v.scl(3.5f);
                    points.add(v);
                }
                Vector2[] v = points.toArray(new Vector2[0]);
                shape.createLoop(v);
                Fixture f = body.createFixture((Shape)shape, 0.0f);
                f.setFriction(0.5f);
                shape.dispose();
            }
            return body;
        }
    }
}

