/*
 * Decompiled with CFR 0.152.
 */
package org.destinationsol.game.particle;

import com.badlogic.gdx.graphics.g2d.ParticleEmitter;
import com.badlogic.gdx.graphics.g2d.Sprite;
import com.badlogic.gdx.graphics.g2d.TextureAtlas;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.math.Vector3;
import com.badlogic.gdx.math.collision.BoundingBox;
import com.badlogic.gdx.utils.Array;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.List;
import org.destinationsol.assets.sound.OggSoundSet;
import org.destinationsol.common.NotNull;
import org.destinationsol.common.SolMath;
import org.destinationsol.common.SolRandom;
import org.destinationsol.game.GameColors;
import org.destinationsol.game.GameDrawer;
import org.destinationsol.game.SolGame;
import org.destinationsol.game.SolObject;
import org.destinationsol.game.drawables.Drawable;
import org.destinationsol.game.drawables.DrawableLevel;
import org.destinationsol.game.particle.EffectConfig;
import org.destinationsol.game.particle.EffectTypes;
import org.destinationsol.game.particle.LightSource;
import org.destinationsol.game.particle.PartMan;
import org.destinationsol.game.planet.Planet;
import org.destinationsol.game.ship.SolShip;
import org.json.JSONObject;

public class DSParticleEmitter {
    private static final float JUMP_SPEED_THRESHOLD = 0.9f;
    private static final float JUMP_SIZE_THRESHOLD = 0.7f;
    private static final float MAX_BOUNDINGBOX_RECALC_AWAIT = 0.5f;
    private static final float MAX_TIME_BETWEEN_POSITION_CHANGE = 0.25f;
    private Vector2 position;
    private String trigger;
    private float angleOffset;
    private boolean hasLight;
    private EffectConfig config;
    private List<String> workSounds;
    private OggSoundSet workSoundSet;
    private List<Drawable> drawables;
    private ParticleEmitter particleEmitter;
    private DrawableLevel drawableLevel;
    private Vector2 relativePosition;
    private Vector2 originalRelativePosition;
    private float relativeAngle;
    private float areaSize;
    private float timeSinceLastPositionChange;
    private float boundingBoxRecalcAwait;
    private ParticleEmitter.ScaledNumericValue originalVelocityAngle;
    private ParticleEmitter.ScaledNumericValue originalRotation;
    private boolean inheritsVelocity;
    private boolean working;
    private boolean floatedUp;
    private BoundingBox boundingBox;
    private LightSource light;
    private SolGame game;

    public DSParticleEmitter(@NotNull Vector2 position, @NotNull String trigger, float angleOffset, boolean hasLight, JSONObject effectConfigNode, List<String> sounds) {
        Preconditions.checkNotNull((Object)position, (Object)"position cannot be null");
        this.position = new Vector2(position);
        this.trigger = (String)Preconditions.checkNotNull((Object)trigger, (Object)"trigger cannot be null");
        this.angleOffset = angleOffset;
        this.hasLight = hasLight;
        this.config = EffectConfig.load(effectConfigNode, new EffectTypes(), new GameColors());
        this.workSounds = sounds;
        this.workSoundSet = null;
        this.drawables = null;
        this.particleEmitter = null;
        this.drawableLevel = null;
        this.relativePosition = null;
        this.originalRelativePosition = null;
        this.relativeAngle = 0.0f;
        this.game = null;
    }

    public DSParticleEmitter(SolGame game, DSParticleEmitter particleEmitter, SolShip ship) {
        this.angleOffset = particleEmitter.getAngleOffset();
        this.hasLight = particleEmitter.getHasLight();
        this.trigger = particleEmitter.getTrigger();
        this.position = particleEmitter.getPosition();
        this.config = particleEmitter.getEffectConfig();
        this.workSoundSet = !particleEmitter.getWorkSounds().isEmpty() ? new OggSoundSet(game.getSoundManager(), particleEmitter.getWorkSounds()) : null;
        Vector2 shipPos = ship.getPosition();
        Vector2 shipVelocity = ship.getVelocity();
        this.initialiseEmitter(this.config, -1.0f, DrawableLevel.PART_BG_0, this.position, true, game, shipPos, shipVelocity, this.angleOffset, this.hasLight);
    }

    public DSParticleEmitter(EffectConfig config, float size, DrawableLevel drawableLevel, Vector2 relativePosition, boolean inheritsVelocity, SolGame game, Vector2 basePosition, Vector2 baseVelocity, float relativeAngle) {
        this.initialiseEmitter(config, size, drawableLevel, relativePosition, inheritsVelocity, game, basePosition, baseVelocity, relativeAngle, false);
    }

    private void initialiseEmitter(EffectConfig config, float size, DrawableLevel drawableLevel, Vector2 relativePosition, boolean inheritsVelocity, SolGame game, Vector2 basePosition, Vector2 baseVelocity, float relativeAngle, boolean hasLight) {
        this.drawables = new ArrayList<Drawable>();
        ParticleEmitterDrawable drawable = new ParticleEmitterDrawable();
        this.drawables.add(drawable);
        this.config = config;
        this.particleEmitter = config.emitter.newEmitter();
        this.drawableLevel = drawableLevel;
        this.relativePosition = new Vector2(relativePosition);
        this.originalRelativePosition = new Vector2(this.relativePosition);
        this.position = new Vector2();
        this.relativeAngle = relativeAngle;
        this.game = game;
        this.light = new LightSource(config.size * 2.5f, true, 0.7f, relativePosition, config.tint);
        if (hasLight) {
            this.light.collectDrawables(this.drawables);
        }
        if (size <= 0.0f) {
            size = config.size;
        }
        if (this.particleEmitter.getSpawnShape().getShape() != ParticleEmitter.SpawnShape.point) {
            this.multiplyValue(this.particleEmitter.getEmission(), size * size);
            this.multiplyValue(this.particleEmitter.getSpawnWidth(), size);
            this.multiplyValue(this.particleEmitter.getSpawnHeight(), size);
            this.areaSize = 0.0f;
        } else if (0.9f < this.particleEmitter.getVelocity().getHighMax()) {
            this.multiplyValue(this.particleEmitter.getEmission(), size * size);
            ParticleEmitter.ScaledNumericValue velocity = this.particleEmitter.getVelocity();
            velocity.setHigh(velocity.getHighMin() * size, velocity.getHighMax() * size);
            this.areaSize = 0.0f;
        } else if (0.7f < this.particleEmitter.getXScale().getHighMax()) {
            ParticleEmitter.ScaledNumericValue scale = this.particleEmitter.getXScale();
            scale.setHigh(scale.getHighMin() * size, scale.getHighMax() * size);
            this.areaSize = 0.0f;
        } else {
            this.areaSize = size;
        }
        this.particleEmitter.setSprites(new Array((Object[])new Sprite[]{new Sprite((TextureRegion)config.tex)}));
        float[] tint = this.particleEmitter.getTint().getColors();
        tint[0] = config.tint.r;
        tint[1] = config.tint.g;
        tint[2] = config.tint.b;
        this.originalVelocityAngle = new ParticleEmitter.ScaledNumericValue();
        this.originalRotation = new ParticleEmitter.ScaledNumericValue();
        DSParticleEmitter.transferAngle(this.particleEmitter.getAngle(), this.originalVelocityAngle, 0.0f);
        DSParticleEmitter.transferAngle(this.particleEmitter.getRotation(), this.originalRotation, 0.0f);
        this.inheritsVelocity = inheritsVelocity;
        this.updateVelocity(game, baseVelocity, basePosition);
        if (config.emitter.continuous) {
            this.particleEmitter.setContinuous(true);
            this.particleEmitter.allowCompletion();
        } else {
            this.particleEmitter.start();
        }
        this.boundingBox = this.particleEmitter.getBoundingBox();
    }

    private void multiplyValue(ParticleEmitter.ScaledNumericValue value, float multiplier) {
        value.setHigh(value.getHighMin() * multiplier, value.getHighMax() * multiplier);
        value.setLow(value.getLowMin() * multiplier, value.getLowMax() * multiplier);
    }

    private static void transferAngle(ParticleEmitter.ScaledNumericValue from, ParticleEmitter.ScaledNumericValue to, float diff) {
        if (!to.isRelative()) {
            to.setHigh(from.getHighMin() + diff, from.getHighMax() + diff);
        }
        to.setLow(from.getLowMin() + diff, from.getLowMax() + diff);
    }

    private void updateVelocity(SolGame game, Vector2 baseVelocity, Vector2 basePosition) {
        if (this.isContinuous() && !this.isWorking() || this.floatedUp) {
            return;
        }
        this.floatedUp = true;
        if (!this.inheritsVelocity) {
            baseVelocity = Vector2.Zero;
        }
        if (!this.config.floatsUp) {
            this.setVelocity(baseVelocity);
            return;
        }
        Planet nearestPlanet = game.getPlanetManager().getNearestPlanet();
        Vector2 velocity = nearestPlanet.getAdjustedEffectVelocity(basePosition, baseVelocity);
        this.setVelocity(velocity);
        SolMath.free(velocity);
    }

    public void onRemove(SolGame game, Vector2 basePos) {
        PartMan partMan = game.getPartMan();
        partMan.finish(game, this, basePos);
    }

    public boolean isComplete() {
        return this.particleEmitter.isComplete();
    }

    public boolean isContinuous() {
        return this.config.emitter.continuous;
    }

    public boolean isWorking() {
        return this.working;
    }

    public void setWorking(boolean working) {
        this.setWorking(working, null);
    }

    public void setWorking(boolean working, SolShip ship) {
        if (working && this.workSoundSet != null) {
            this.game.getSoundManager().play(this.game, this.workSoundSet, this.position, ship);
        }
        this.light.update(working, this.relativeAngle, this.game);
        if (!this.isContinuous()) {
            throw new AssertionError((Object)"only continuous emitters can start working");
        }
        if (this.working == working) {
            return;
        }
        this.working = working;
        if (working) {
            this.particleEmitter.start();
        } else {
            this.particleEmitter.allowCompletion();
        }
    }

    private void setVelocity(Vector2 velocity) {
        ParticleEmitter.ScaledNumericValue wind = this.particleEmitter.getWind();
        wind.setActive(true);
        wind.setHigh(velocity.x);
        wind.setLow(velocity.x);
        ParticleEmitter.ScaledNumericValue gravity = this.particleEmitter.getGravity();
        gravity.setActive(true);
        gravity.setHigh(velocity.y);
        gravity.setLow(velocity.y);
    }

    public Vector2 getPosition() {
        return this.position;
    }

    public String getTrigger() {
        return this.trigger;
    }

    public float getAngleOffset() {
        return this.angleOffset;
    }

    public boolean getHasLight() {
        return this.hasLight;
    }

    public EffectConfig getEffectConfig() {
        return this.config;
    }

    public List<String> getWorkSounds() {
        return this.workSounds;
    }

    public List<Drawable> getDrawables() {
        return this.drawables;
    }

    public class ParticleEmitterDrawable
    implements Drawable {
        @Override
        public void update(SolGame game, SolObject object) {
            this.maybeSwitchRelativePosition(game);
            Vector2 basePos = object.getPosition();
            float baseAngle = object.getAngle();
            SolMath.toWorld(DSParticleEmitter.this.position, DSParticleEmitter.this.relativePosition, baseAngle, basePos);
            float timeStep = game.getTimeStep();
            ((DSParticleEmitter)DSParticleEmitter.this).position.x -= DSParticleEmitter.this.particleEmitter.getWind().getLowMin() * timeStep;
            ((DSParticleEmitter)DSParticleEmitter.this).position.y -= DSParticleEmitter.this.particleEmitter.getGravity().getLowMin() * timeStep;
            DSParticleEmitter.this.particleEmitter.setPosition(((DSParticleEmitter)DSParticleEmitter.this).position.x, ((DSParticleEmitter)DSParticleEmitter.this).position.y);
            DSParticleEmitter.transferAngle(DSParticleEmitter.this.originalVelocityAngle, DSParticleEmitter.this.particleEmitter.getAngle(), baseAngle + DSParticleEmitter.this.relativeAngle);
            DSParticleEmitter.transferAngle(DSParticleEmitter.this.originalRotation, DSParticleEmitter.this.particleEmitter.getRotation(), baseAngle + DSParticleEmitter.this.relativeAngle);
            DSParticleEmitter.this.updateVelocity(game, object.getVelocity(), object.getPosition());
            DSParticleEmitter.this.particleEmitter.update(timeStep);
            if (DSParticleEmitter.this.boundingBoxRecalcAwait > 0.0f) {
                DSParticleEmitter.this.boundingBoxRecalcAwait -= game.getTimeStep();
            } else {
                DSParticleEmitter.this.boundingBoxRecalcAwait = 0.5f;
                DSParticleEmitter.this.particleEmitter.getBoundingBox();
            }
        }

        private void maybeSwitchRelativePosition(SolGame game) {
            if (DSParticleEmitter.this.areaSize == 0.0f) {
                return;
            }
            float timeStep = game.getTimeStep();
            DSParticleEmitter.this.timeSinceLastPositionChange += timeStep;
            if (!DSParticleEmitter.this.working || DSParticleEmitter.this.timeSinceLastPositionChange < 0.25f) {
                return;
            }
            DSParticleEmitter.this.timeSinceLastPositionChange = 0.0f;
            SolMath.fromAl(DSParticleEmitter.this.relativePosition, SolRandom.randomFloat(180.0f), SolRandom.randomFloat(0.0f, DSParticleEmitter.this.areaSize));
            DSParticleEmitter.this.relativePosition.add(DSParticleEmitter.this.originalRelativePosition);
        }

        @Override
        public void prepare(SolObject object) {
        }

        @Override
        public Vector2 getPosition() {
            return DSParticleEmitter.this.position;
        }

        @Override
        public Vector2 getRelativePosition() {
            return DSParticleEmitter.this.relativePosition;
        }

        @Override
        public float getRadius() {
            Vector3 center = new Vector3();
            center = DSParticleEmitter.this.boundingBox.getCenter(center);
            float toCenter = DSParticleEmitter.this.position.dst(center.x, center.y);
            float radius = DSParticleEmitter.this.boundingBox.getDimensions(center).len() / 2.0f;
            return radius > 0.0f ? toCenter + radius : 0.0f;
        }

        @Override
        public void draw(GameDrawer drawer, SolGame game) {
            drawer.draw(DSParticleEmitter.this.particleEmitter, ((DSParticleEmitter)DSParticleEmitter.this).config.tex, ((DSParticleEmitter)DSParticleEmitter.this).config.emitter.additive);
        }

        @Override
        public boolean isEnabled() {
            return true;
        }

        @Override
        public boolean okToRemove() {
            return DSParticleEmitter.this.isComplete();
        }

        @Override
        public DrawableLevel getLevel() {
            return DSParticleEmitter.this.drawableLevel;
        }

        @Override
        public TextureAtlas.AtlasRegion getTexture() {
            return ((DSParticleEmitter)DSParticleEmitter.this).config.tex;
        }
    }
}

