/*
 * Decompiled with CFR 0.152.
 */
package org.destinationsol.game.particle;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.TextureAtlas;
import java.util.ArrayList;
import java.util.List;
import org.destinationsol.assets.Assets;
import org.destinationsol.game.GameColors;
import org.destinationsol.game.particle.EffectType;
import org.destinationsol.game.particle.EffectTypes;
import org.json.JSONObject;

public class EffectConfig {
    public final EffectType emitter;
    public final float size;
    public final TextureAtlas.AtlasRegion tex;
    public final boolean floatsUp;
    public final Color tint;

    public EffectConfig(EffectType emitter, float size, TextureAtlas.AtlasRegion texture, boolean floatsUp, Color tint) {
        this.emitter = emitter;
        this.size = size;
        this.tex = texture;
        this.floatsUp = floatsUp;
        this.tint = tint;
    }

    public static EffectConfig load(JSONObject node, EffectTypes types, GameColors colours) {
        if (node == null) {
            return null;
        }
        String emitter = node.getString("effectFile");
        EffectType effectType = types.forName(emitter);
        float size = (float)node.optDouble("size", 0.0);
        String textureName = node.getString("tex");
        boolean floatsUp = node.optBoolean("floatsUp", false);
        Color tint = colours.load(node.getString("tint"));
        TextureAtlas.AtlasRegion tex = Assets.getAtlasRegion(textureName + "Particle");
        return new EffectConfig(effectType, size, tex, floatsUp, tint);
    }

    public static List<EffectConfig> loadList(ArrayList<JSONObject> listNode, EffectTypes types, GameColors colours) {
        ArrayList<EffectConfig> configs = new ArrayList<EffectConfig>();
        for (JSONObject node : listNode) {
            configs.add(EffectConfig.load(node, types, colours));
        }
        return configs;
    }
}

