/*
 * Decompiled with CFR 0.152.
 */
package org.destinationsol.game.particle;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.math.Vector2;
import java.util.List;
import org.destinationsol.common.SolColorUtil;
import org.destinationsol.common.SolMath;
import org.destinationsol.common.SolRandom;
import org.destinationsol.game.SolGame;
import org.destinationsol.game.drawables.Drawable;
import org.destinationsol.game.drawables.DrawableLevel;
import org.destinationsol.game.drawables.RectSprite;
import org.destinationsol.game.drawables.SpriteManager;

public class LightSource {
    public static final float DEFAULT_FADE_TIME = 0.1f;
    public static final float A_RATIO = 0.5f;
    public static final float SZ_RATIO = 0.8f;
    private static final String CIRCLE_SPRITE_NAME = "core:lightCircleParticle";
    private static final String HALO_SPRITE_NAME = "core:lightHaloParticle";
    private final RectSprite circle;
    private final RectSprite halo;
    private final float size;
    private final float intensity;
    private float workPercentage;
    private float fadeTime;

    public LightSource(float size, boolean hasHalo, float intensity, Vector2 relativePosition, Color colour) {
        this.size = size;
        Vector2 relPos1 = new Vector2(relativePosition);
        this.circle = SpriteManager.createSprite(CIRCLE_SPRITE_NAME, DrawableLevel.PART_BG_0, relPos1, colour, true);
        if (hasHalo) {
            Color haloCol = new Color(colour);
            SolColorUtil.changeBrightness(haloCol, 0.8f);
            this.halo = SpriteManager.createSprite(HALO_SPRITE_NAME, DrawableLevel.PART_BG_0, relativePosition, haloCol, true);
        } else {
            this.halo = null;
        }
        this.intensity = intensity;
        this.fadeTime = 0.1f;
    }

    public void update(boolean working, float baseAngle, SolGame game) {
        this.workPercentage = working ? 1.0f : SolMath.approach(this.workPercentage, 0.0f, game.getTimeStep() / this.fadeTime);
        float baseA = SolRandom.randomFloat(0.5f, 1.0f) * this.workPercentage * this.intensity;
        this.circle.tint.a = baseA * 0.5f;
        float sz = (1.0f + SolRandom.randomFloat(0.2f * this.intensity)) * this.size;
        this.circle.setTextureSize(0.8f * sz);
        if (this.halo != null) {
            this.halo.tint.a = baseA;
            this.halo.relativeAngle = game.getCam().getAngle() - baseAngle;
            this.halo.setTextureSize(sz);
        }
    }

    public boolean isFinished() {
        return this.workPercentage <= 0.0f;
    }

    public void collectDrawables(List<Drawable> drawables) {
        drawables.add(this.circle);
        if (this.halo != null) {
            drawables.add(this.halo);
        }
    }

    public void setFadeTime(float fadeTime) {
        this.fadeTime = fadeTime;
    }

    public void setWorking() {
        this.workPercentage = 1.0f;
    }

    public void setRelativePosition(Vector2 relativePosition) {
        this.circle.relativePosition.set(relativePosition);
    }
}

