/*
 * Decompiled with CFR 0.152.
 */
package org.destinationsol.game.particle;

import com.badlogic.gdx.graphics.g2d.TextureAtlas;
import com.badlogic.gdx.math.Vector2;
import java.util.ArrayList;
import org.destinationsol.common.SolColor;
import org.destinationsol.common.SolMath;
import org.destinationsol.common.SolRandom;
import org.destinationsol.game.SolGame;
import org.destinationsol.game.drawables.Drawable;
import org.destinationsol.game.drawables.DrawableLevel;
import org.destinationsol.game.drawables.DrawableObject;
import org.destinationsol.game.drawables.RectSprite;
import org.destinationsol.game.drawables.SpriteManager;
import org.destinationsol.game.particle.DSParticleEmitter;
import org.destinationsol.game.particle.LightObject;
import org.destinationsol.game.ship.SolShip;
import org.destinationsol.game.ship.hulls.Hull;

public class PartMan {
    public static final float EXPL_LIGHT_MAX_SZ = 0.4f;
    public static final float EXPL_LIGHT_MAX_FADE_TIME = 0.8f;
    public static final float SZ_TO_BLINK_COUNT = 18.0f;

    public void finish(SolGame game, DSParticleEmitter emitter, Vector2 basePosition) {
        if (emitter.isContinuous()) {
            emitter.setWorking(false);
        }
        ArrayList<Drawable> drawables = new ArrayList<Drawable>();
        drawables.addAll(emitter.getDrawables());
        DrawableObject drawableObject = new DrawableObject(drawables, new Vector2(basePosition), new Vector2(), null, true, false);
        game.getObjectManager().addObjDelayed(drawableObject);
    }

    public void blinks(Vector2 position, SolGame game, float size) {
        int count = (int)(18.0f * size * size);
        for (int i = 0; i < count; ++i) {
            Vector2 lightPos = new Vector2();
            SolMath.fromAl(lightPos, SolRandom.randomFloat(180.0f), SolRandom.randomFloat(0.0f, size / 2.0f));
            lightPos.add(position);
            float lightSize = SolRandom.randomFloat(0.5f, 1.0f) * 0.4f;
            float fadeTime = SolRandom.randomFloat(0.5f, 1.0f) * 0.8f;
            LightObject light = new LightObject(lightSize, true, 1.0f, lightPos, fadeTime, game.getCols().fire);
            game.getObjectManager().addObjDelayed(light);
        }
    }

    public void shieldSpark(SolGame game, Vector2 collPos, Hull hull, TextureAtlas.AtlasRegion shieldTexture, float perc) {
        if (perc <= 0.0f) {
            return;
        }
        Vector2 position = hull.getPosition();
        float angle = SolMath.angle(position, collPos);
        float sz = hull.config.getSize() * 0.7f * 2.0f;
        float alphaSum = perc * 3.0f;
        RectSprite s = null;
        int count = (int)alphaSum + 1;
        for (int i = 0; i < count; ++i) {
            s = this.blip(game, position, angle, sz, 0.5f, hull.getVelocity(), shieldTexture);
        }
        float lastTint = SolMath.clamp(alphaSum - (float)((int)alphaSum));
        if (s != null) {
            s.tint.a = lastTint;
            s.baseAlpha = lastTint;
        }
    }

    public RectSprite blip(SolGame game, Vector2 position, float angle, float size, float fadeTime, Vector2 velocity, TextureAtlas.AtlasRegion texture) {
        RectSprite sprite = SpriteManager.createStaticSprite(texture, size, 0.0f, 0.0f, new Vector2(), DrawableLevel.PART_FG_0, angle, 0.0f, SolColor.WHITE, true);
        ArrayList<Drawable> drawables = new ArrayList<Drawable>();
        drawables.add(sprite);
        DrawableObject o = new DrawableObject(drawables, new Vector2(position), new Vector2(velocity), null, false, false);
        o.fade(fadeTime);
        game.getObjectManager().addObjDelayed(o);
        return sprite;
    }

    public void updateAllHullEmittersOfType(SolShip ship, String triggerType, boolean on) {
        for (DSParticleEmitter particleEmitter : ship.getHull().getParticleEmitters()) {
            if (!triggerType.equals(particleEmitter.getTrigger())) continue;
            particleEmitter.setWorking(on, ship);
        }
    }
}

