/*
 * Decompiled with CFR 0.152.
 */
package org.destinationsol.game.particle;

import com.badlogic.gdx.math.Vector2;
import java.util.ArrayList;
import java.util.List;
import org.destinationsol.assets.json.Validator;
import org.destinationsol.game.GameColors;
import org.destinationsol.game.SolGame;
import org.destinationsol.game.drawables.DrawableLevel;
import org.destinationsol.game.particle.DSParticleEmitter;
import org.destinationsol.game.particle.EffectConfig;
import org.destinationsol.game.particle.EffectTypes;
import org.destinationsol.game.particle.PartMan;
import org.json.JSONObject;

public class SpecialEffects {
    public final EffectConfig starPortFlow;
    public final EffectConfig transcendentWork;
    private final EffectConfig smoke;
    private final EffectConfig fire;
    private final EffectConfig electricity;
    private final EffectConfig shipExplosionSmoke;
    private final EffectConfig shipExplosionFire;
    private final EffectConfig asteroidDust;
    private final EffectConfig forceBeacon;

    public SpecialEffects(EffectTypes effectTypes, GameColors colours) {
        JSONObject rootNode = Validator.getValidatedJSON("core:specialEffectsConfig", "engine:schemaSpecialEffectsConfig");
        this.smoke = EffectConfig.load(rootNode.getJSONObject("smoke"), effectTypes, colours);
        this.fire = EffectConfig.load(rootNode.getJSONObject("fire"), effectTypes, colours);
        this.electricity = EffectConfig.load(rootNode.getJSONObject("electricity"), effectTypes, colours);
        this.shipExplosionSmoke = EffectConfig.load(rootNode.getJSONObject("shipExplosionSmoke"), effectTypes, colours);
        this.shipExplosionFire = EffectConfig.load(rootNode.getJSONObject("shipExplosionFire"), effectTypes, colours);
        this.asteroidDust = EffectConfig.load(rootNode.getJSONObject("asteroidDust"), effectTypes, colours);
        this.forceBeacon = EffectConfig.load(rootNode.getJSONObject("forceBeacon"), effectTypes, colours);
        this.starPortFlow = EffectConfig.load(rootNode.getJSONObject("starPortFlow"), effectTypes, colours);
        this.transcendentWork = EffectConfig.load(rootNode.getJSONObject("transcendentWork"), effectTypes, colours);
    }

    public List<DSParticleEmitter> buildBodyEffs(float objRad, SolGame game, Vector2 position, Vector2 velocity) {
        ArrayList<DSParticleEmitter> res = new ArrayList<DSParticleEmitter>();
        float sz = objRad * 0.9f;
        DSParticleEmitter smoke = new DSParticleEmitter(this.smoke, sz, DrawableLevel.PART_FG_0, new Vector2(), true, game, position, velocity, 0.0f);
        res.add(smoke);
        DSParticleEmitter fire = new DSParticleEmitter(this.fire, sz, DrawableLevel.PART_FG_1, new Vector2(), true, game, position, velocity, 0.0f);
        res.add(fire);
        DSParticleEmitter electricity = new DSParticleEmitter(this.electricity, objRad * 1.2f, DrawableLevel.PART_FG_0, new Vector2(), true, game, position, velocity, 0.0f);
        res.add(electricity);
        return res;
    }

    public void explodeShip(SolGame game, Vector2 position, float size) {
        PartMan pm = game.getPartMan();
        DSParticleEmitter smoke = new DSParticleEmitter(this.shipExplosionSmoke, 2.0f * size, DrawableLevel.PART_FG_0, new Vector2(), false, game, position, Vector2.Zero, 0.0f);
        pm.finish(game, smoke, position);
        DSParticleEmitter fire = new DSParticleEmitter(this.shipExplosionFire, 0.7f * size, DrawableLevel.PART_FG_1, new Vector2(), false, game, position, Vector2.Zero, 0.0f);
        pm.finish(game, fire, position);
        pm.blinks(position, game, size);
    }

    public void asteroidDust(SolGame game, Vector2 position, Vector2 velocity, float size) {
        DSParticleEmitter smoke = new DSParticleEmitter(this.asteroidDust, size, DrawableLevel.PART_FG_0, new Vector2(), true, game, position, velocity, 0.0f);
        game.getPartMan().finish(game, smoke, position);
    }

    public DSParticleEmitter buildForceBeacon(float size, SolGame game, Vector2 relativePosition, Vector2 basePosition, Vector2 velocity) {
        return new DSParticleEmitter(this.forceBeacon, size, DrawableLevel.PART_FG_0, relativePosition, false, game, basePosition, velocity, 0.0f);
    }
}

