/*
 * Decompiled with CFR 0.152.
 */
package org.destinationsol.game.planet;

import com.badlogic.gdx.graphics.g2d.TextureAtlas;
import com.badlogic.gdx.math.Vector2;
import java.util.ArrayList;
import java.util.List;
import org.destinationsol.assets.Assets;
import org.destinationsol.common.SolMath;
import org.json.JSONObject;

public class DecoConfig {
    public final float density;
    public final float szMin;
    public final float szMax;
    public final Vector2 orig;
    public final boolean allowFlip;
    public final List<TextureAtlas.AtlasRegion> texs;

    public DecoConfig(float density, float szMin, float szMax, Vector2 orig, boolean allowFlip, List<TextureAtlas.AtlasRegion> texs) {
        this.density = density;
        this.szMin = szMin;
        this.szMax = szMax;
        this.orig = orig;
        this.allowFlip = allowFlip;
        this.texs = texs;
    }

    static List<DecoConfig> load(JSONObject planetConfig) {
        ArrayList<DecoConfig> res = new ArrayList<DecoConfig>();
        JSONObject decorations = planetConfig.getJSONObject("decorations");
        for (String s : decorations.keySet()) {
            if (!(decorations.get(s) instanceof JSONObject)) continue;
            JSONObject deco = decorations.getJSONObject(s);
            float density = (float)deco.getDouble("density");
            float szMin = (float)deco.getDouble("szMin");
            float szMax = (float)deco.getDouble("szMax");
            Vector2 orig = SolMath.readV2(deco, "orig");
            boolean allowFlip = deco.getBoolean("allowFlip");
            String texName = s;
            List<TextureAtlas.AtlasRegion> texs = Assets.listTexturesMatching(texName + "_.*");
            DecoConfig c = new DecoConfig(density, szMin, szMax, orig, allowFlip, texs);
            res.add(c);
        }
        return res;
    }
}

