/*
 * Decompiled with CFR 0.152.
 */
package org.destinationsol.game.planet;

import com.badlogic.gdx.math.Vector2;
import java.util.List;
import org.destinationsol.common.SolMath;
import org.destinationsol.game.FarObject;
import org.destinationsol.game.SolGame;
import org.destinationsol.game.SolObject;
import org.destinationsol.game.drawables.Drawable;
import org.destinationsol.game.drawables.DrawableManager;
import org.destinationsol.game.planet.Planet;
import org.destinationsol.game.planet.PlanetSprites;

public class FarPlanetSprites
implements FarObject {
    private final Planet planet;
    private final float distance;
    private final List<Drawable> drawables;
    private final float radius;
    private final float RotationSpeedToPlanet;
    private float relativeAngleToPlanet;
    private Vector2 position;

    public FarPlanetSprites(Planet planet, float relAngleToPlanet, float dist, List<Drawable> drawables, float toPlanetRotationSpeed) {
        this.planet = planet;
        this.relativeAngleToPlanet = relAngleToPlanet;
        this.distance = dist;
        this.drawables = drawables;
        this.radius = DrawableManager.radiusFromDrawables(this.drawables);
        this.RotationSpeedToPlanet = toPlanetRotationSpeed;
        this.position = new Vector2();
    }

    @Override
    public boolean shouldBeRemoved(SolGame game) {
        return false;
    }

    @Override
    public SolObject toObject(SolGame game) {
        return new PlanetSprites(this.planet, this.relativeAngleToPlanet, this.distance, this.drawables, this.RotationSpeedToPlanet);
    }

    @Override
    public void update(SolGame game) {
        this.relativeAngleToPlanet += this.RotationSpeedToPlanet * game.getTimeStep();
        if (game.getPlanetManager().getNearestPlanet() == this.planet) {
            SolMath.fromAl(this.position, this.planet.getAngle() + this.relativeAngleToPlanet, this.distance);
            this.position.add(this.planet.getPosition());
        }
    }

    @Override
    public float getRadius() {
        return this.radius;
    }

    @Override
    public Vector2 getPosition() {
        return this.position;
    }

    @Override
    public String toDebugString() {
        return null;
    }

    @Override
    public boolean hasBody() {
        return false;
    }
}

