/*
 * Decompiled with CFR 0.152.
 */
package org.destinationsol.game.planet;

import com.badlogic.gdx.math.Vector2;
import org.destinationsol.common.SolMath;
import org.destinationsol.game.FarObject;
import org.destinationsol.game.SolGame;
import org.destinationsol.game.SolObject;
import org.destinationsol.game.planet.Planet;
import org.destinationsol.game.planet.Tile;
import org.destinationsol.game.planet.TileObjBuilder;

public class FarTileObject
implements FarObject {
    private final Planet myPlanet;
    private final float myToPlanetAngle;
    private final float myDist;
    private final float mySize;
    private final Tile myTile;
    private final Vector2 position;
    private final float myRadius;

    public FarTileObject(Planet planet, float toPlanetAngle, float dist, float size, Tile tile) {
        this.myPlanet = planet;
        this.myToPlanetAngle = toPlanetAngle;
        this.myDist = dist;
        this.mySize = size;
        this.myRadius = SolMath.sqrt(2.0f) * this.mySize;
        this.myTile = tile;
        this.position = new Vector2();
    }

    @Override
    public boolean shouldBeRemoved(SolGame game) {
        return false;
    }

    @Override
    public SolObject toObject(SolGame game) {
        return new TileObjBuilder().build(game, this.mySize, this.myToPlanetAngle, this.myDist, this.myTile, this.myPlanet);
    }

    @Override
    public void update(SolGame game) {
        if (game.getPlanetManager().getNearestPlanet() == this.myPlanet) {
            SolMath.fromAl(this.position, this.myPlanet.getAngle() + this.myToPlanetAngle, this.myDist);
            this.position.add(this.myPlanet.getPosition());
        }
    }

    @Override
    public float getRadius() {
        return this.myRadius;
    }

    @Override
    public Vector2 getPosition() {
        return this.position;
    }

    @Override
    public String toDebugString() {
        return null;
    }

    @Override
    public boolean hasBody() {
        return true;
    }

    public float getAngle() {
        return this.myPlanet.getAngle() + this.myToPlanetAngle + 90.0f;
    }

    public Planet getPlanet() {
        return this.myPlanet;
    }

    public float getSz() {
        return this.mySize;
    }

    public Tile getTile() {
        return this.myTile;
    }
}

