/*
 * Decompiled with CFR 0.152.
 */
package org.destinationsol.game.planet;

import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.physics.box2d.Fixture;
import com.badlogic.gdx.physics.box2d.RayCastCallback;
import org.destinationsol.common.SolMath;
import org.destinationsol.common.SolRandom;
import org.destinationsol.game.SolGame;
import org.destinationsol.game.planet.ConsumedAngles;
import org.destinationsol.game.planet.Planet;
import org.destinationsol.game.planet.TileObject;

public class FlatPlaceFinder {
    private final Vector2 vector = new Vector2();
    private float deviation;
    private final RayCastCallback myRayBack = new RayCastCallback(){

        public float reportRayFixture(Fixture fixture, Vector2 point, Vector2 normal, float fraction) {
            if (!(fixture.getBody().getUserData() instanceof TileObject)) {
                return -1.0f;
            }
            FlatPlaceFinder.this.vector.set(point);
            FlatPlaceFinder.this.deviation = SolMath.abs(SolMath.angle(normal) + 90.0f);
            return fraction;
        }
    };

    public Vector2 find(SolGame game, Planet planet, ConsumedAngles takenAngles, float objHalfWidth) {
        Vector2 pPos = planet.getPosition();
        Vector2 result = new Vector2(pPos);
        float minDeviation = 90.0f;
        float resAngle = 0.0f;
        float objAngularHalfWidth = SolMath.angularWidthOfSphere(objHalfWidth, planet.getGroundHeight());
        for (int i = 0; i < 20; ++i) {
            float angle = SolRandom.randomFloat(180.0f);
            if (takenAngles != null && takenAngles.isConsumed(angle, objAngularHalfWidth)) continue;
            this.deviation = angle;
            SolMath.fromAl(this.vector, angle, planet.getFullHeight());
            this.vector.add(pPos);
            game.getObjectManager().getWorld().rayCast(this.myRayBack, this.vector, pPos);
            if (!(this.deviation < minDeviation)) continue;
            result.set(this.vector);
            minDeviation = this.deviation;
            resAngle = angle;
        }
        if (takenAngles != null) {
            takenAngles.add(resAngle, objAngularHalfWidth);
        }
        result.sub(pPos);
        SolMath.rotate(result, -planet.getAngle());
        return result;
    }
}

