/*
 * Decompiled with CFR 0.152.
 */
package org.destinationsol.game.planet;

import org.destinationsol.common.SolRandom;
import org.destinationsol.game.planet.PlanetConfig;
import org.destinationsol.game.planet.SurfaceDirection;
import org.destinationsol.game.planet.Tile;

public class GroundBuilder {
    private static final int PURE_GROUND_ROWS = 0;
    private final PlanetConfig config;
    private final int columns;
    private final int rows;
    private final boolean[][] dungeon;
    private final Tile[][] map;

    GroundBuilder(PlanetConfig planetConfig, int cols, int rows) {
        this.config = planetConfig;
        this.columns = cols;
        this.rows = rows;
        this.dungeon = new boolean[cols][rows];
        this.map = new Tile[cols][rows];
    }

    public Tile[][] build() {
        float[] ds0 = new float[this.columns];
        float desiredMin = 0.0f;
        float desiredMax = this.rows - 0;
        for (int x = 0; x < this.columns; ++x) {
            ds0[x] = SolRandom.randomFloat(desiredMin, desiredMax);
        }
        float[] ds = new float[this.columns];
        if (this.config.smoothLandscape) {
            this.smooth(ds0, desiredMin, desiredMax, ds);
        } else {
            System.arraycopy(ds0, 0, ds, 0, ds0.length);
        }
        int nextD = (int)ds[0];
        for (int col = 0; col < this.columns; ++col) {
            int prevD = nextD;
            nextD = col == this.columns - 1 ? (int)ds[0] : (int)ds[col];
            for (int row = 0; row < this.rows; ++row) {
                SurfaceDirection from = SurfaceDirection.FWD;
                SurfaceDirection to = SurfaceDirection.FWD;
                if (row < prevD) {
                    from = SurfaceDirection.DOWN;
                } else if (row > prevD) {
                    from = SurfaceDirection.UP;
                }
                if (row < nextD) {
                    to = SurfaceDirection.DOWN;
                } else if (row > nextD) {
                    to = SurfaceDirection.UP;
                }
                if (from == SurfaceDirection.DOWN && to == SurfaceDirection.DOWN) continue;
                this.map[col][row] = this.config.planetTiles.getGround(from, to);
            }
        }
        return this.map;
    }

    private void smooth(float[] ds0, float desiredMin, float desiredMax, float[] ds) {
        float min = Float.MAX_VALUE;
        float max = Float.MIN_VALUE;
        for (int x = 0; x < this.columns; ++x) {
            float prev = x == 0 ? ds0[this.columns - 1] : ds0[x - 1];
            float next = x == this.columns - 1 ? ds0[0] : ds0[x + 1];
            ds[x] = 0.25f * (prev + next) + 0.5f * ds0[x];
            if (ds[x] < min) {
                min = ds[x];
            }
            if (!(max < ds[x])) continue;
            max = ds[x];
        }
        float shift = min - desiredMin;
        float mul = (desiredMax - 0.01f - desiredMin) / (max - min);
        for (int x = 0; x < this.columns; ++x) {
            ds[x] = mul * (ds[x] - shift);
        }
    }

    private void createDungeon() {
        int nodeCount = 3;
        for (int i = 0; i < nodeCount; ++i) {
            int col = (int)(1.0f * (float)this.columns * (float)i / (float)nodeCount);
            this.buildNode(col);
        }
        for (int col = 0; col < this.columns; ++col) {
            for (int row = 0; row < this.rows; ++row) {
                if (!this.dungeon[col][row]) continue;
                this.map[col][row] = this.isGround(col, row) ? this.getDungeonTile(col, row) : this.getEntranceTile(col, row);
            }
        }
    }

    private Tile getEntranceTile(int col, int row) {
        boolean down = this.isGround(col, row + 1);
        boolean left = this.isGround(this.left(col), row);
        boolean right = this.isGround(this.right(col), row);
        return this.config.planetTiles.getDungeonEntrance(down, left, right);
    }

    private Tile getDungeonTile(int col, int row) {
        return null;
    }

    private void buildNode(int col) {
        int row = this.rows - SolRandom.randomInt(0, 0);
        this.buildTunnel(col, row, true);
        this.buildTunnel(col, row, false);
    }

    private void buildTunnel(int col, int row, boolean toLeft) {
        float currSpace = 0.0f;
        this.addToDungeon(col, row);
        block0: while (true) {
            col = toLeft ? this.left(col) : this.right(col);
            currSpace += SolRandom.randomFloat(0.5f, SolRandom.test(0.3f) ? 4.0f : 1.0f);
            if (this.addToDungeon(col, row)) {
                return;
            }
            do {
                if (!(currSpace > 0.0f)) continue block0;
                currSpace -= 1.0f;
            } while (!this.addToDungeon(col, --row));
            break;
        }
    }

    private boolean addToDungeon(int col, int row) {
        this.dungeon[col][row] = true;
        return !this.isGround(col, row);
    }

    private boolean isGround(int col, int row) {
        Tile t = this.map[col][row];
        return t != null && t.from == SurfaceDirection.UP && t.to == SurfaceDirection.UP;
    }

    private int left(int col) {
        return col == 0 ? this.columns - 1 : col - 1;
    }

    private int right(int col) {
        return col == this.columns - 1 ? 0 : col + 1;
    }
}

