/*
 * Decompiled with CFR 0.152.
 */
package org.destinationsol.game.planet;

import com.badlogic.gdx.math.Vector2;
import java.util.ArrayList;
import java.util.List;
import org.destinationsol.common.Bound;
import org.destinationsol.common.SolMath;
import org.destinationsol.common.SolRandom;
import org.destinationsol.game.HardnessCalc;
import org.destinationsol.game.SolGame;
import org.destinationsol.game.planet.PlanetConfig;
import org.destinationsol.game.planet.PlanetObjectsBuilder;
import org.destinationsol.game.planet.SolSystem;

public class Planet {
    private final SolSystem system;
    private final Vector2 position;
    private final float distance;
    private final float rotationSpeedInSystem;
    private final float rotationSpeed;
    private final float groundHeight;
    private final PlanetConfig config;
    private final String name;
    private final float gravitationConstant;
    private final List<Vector2> landingPlaces;
    private final float groundDamagePerSecond;
    private final float atmosphereDamagePerSecond;
    private boolean areObjectsCreated;
    private float angleInSystem;
    private float angle;
    private float minGroundHeight;
    private Vector2 velocity;

    public Planet(SolSystem sys, float angleToSys, float dist, float angle, float toSysRotationSpeed, float rotationSpeed, float groundHeight, boolean objsCreated, PlanetConfig config, String name) {
        this.system = sys;
        this.angleInSystem = angleToSys;
        this.distance = dist;
        this.angle = angle;
        this.rotationSpeedInSystem = toSysRotationSpeed;
        this.rotationSpeed = rotationSpeed;
        this.groundHeight = groundHeight;
        this.config = config;
        this.name = name;
        this.minGroundHeight = this.groundHeight;
        this.areObjectsCreated = objsCreated;
        this.position = new Vector2();
        this.velocity = new Vector2();
        float grav = SolRandom.randomFloat(config.minGrav, config.maxGrav);
        this.gravitationConstant = grav * this.groundHeight * this.groundHeight;
        this.groundDamagePerSecond = HardnessCalc.getGroundDps(config, grav);
        this.atmosphereDamagePerSecond = HardnessCalc.getAtmDps(config);
        this.landingPlaces = new ArrayList<Vector2>();
        this.setSecondaryParams();
    }

    public void update(SolGame game, float timeStep) {
        this.angleInSystem += this.rotationSpeedInSystem * timeStep;
        this.angle += this.rotationSpeed * timeStep;
        this.setSecondaryParams();
        Vector2 camPos = game.getCam().getPosition();
        if (!this.areObjectsCreated && camPos.dst(this.position) < this.getGroundHeight() + 21.0f) {
            this.minGroundHeight = new PlanetObjectsBuilder().createPlanetObjs(game, this);
            this.fillLangingPlaces(game);
            this.areObjectsCreated = true;
        }
    }

    private void setSecondaryParams() {
        SolMath.fromAl(this.position, this.angleInSystem, this.distance);
        this.position.add(this.system.getPosition());
        float speed = SolMath.angleToArc(this.rotationSpeedInSystem, this.distance);
        float velocityAngle = this.angleInSystem + 90.0f;
        SolMath.fromAl(this.velocity, velocityAngle, speed);
    }

    private void fillLangingPlaces(SolGame game) {
        for (int i = 0; i < 10; ++i) {
            Vector2 landingPlace = game.getPlanetManager().findFlatPlace(game, this, null, 0.0f);
            this.landingPlaces.add(landingPlace);
        }
    }

    public float getAngle() {
        return this.angle;
    }

    public Vector2 getPosition() {
        return this.position;
    }

    public float getFullHeight() {
        return this.groundHeight + 14.0f;
    }

    public float getGroundHeight() {
        return this.groundHeight;
    }

    public SolSystem getSystem() {
        return this.system;
    }

    @Bound
    public Vector2 getAdjustedEffectVelocity(Vector2 position, Vector2 velocity) {
        Vector2 r = SolMath.getVec(velocity);
        if (this.config.skyConfig == null) {
            return r;
        }
        Vector2 up = SolMath.distVec(this.position, position);
        float dst = up.len();
        if (dst == 0.0f || this.getFullHeight() < dst) {
            SolMath.free(up);
            return r;
        }
        float smokeConst = 1.2f * this.gravitationConstant;
        if (dst < this.groundHeight) {
            up.scl(smokeConst / dst / this.groundHeight / this.groundHeight);
            r.set(up);
            SolMath.free(up);
            return r;
        }
        float speedPercentage = (dst - this.groundHeight) / 14.0f;
        r.scl(speedPercentage);
        up.scl(smokeConst / dst / dst / dst);
        r.add(up);
        SolMath.free(up);
        return r;
    }

    public float getGravitationConstant() {
        return this.gravitationConstant;
    }

    public float getDistance() {
        return this.distance;
    }

    public float getAngleInSystem() {
        return this.angleInSystem;
    }

    public float getRotationSpeed() {
        return this.rotationSpeed;
    }

    public boolean areObjectsCreated() {
        return this.areObjectsCreated;
    }

    public List<Vector2> getLandingPlaces() {
        return this.landingPlaces;
    }

    public float getMinGroundHeight() {
        return this.minGroundHeight;
    }

    public boolean isNearGround(Vector2 position) {
        return this.position.dst(position) - this.groundHeight < 3.5f;
    }

    public PlanetConfig getConfig() {
        return this.config;
    }

    public float getRotationSpeedInSystem() {
        return this.rotationSpeedInSystem;
    }

    public String getName() {
        return this.name;
    }

    public void calculateVelocityAtPosition(Vector2 velocity, Vector2 position) {
        Vector2 toPos = SolMath.distVec(this.position, position);
        float fromPlanetAngle = SolMath.angle(toPos);
        float hSpeed = SolMath.angleToArc(this.rotationSpeed, toPos.len());
        SolMath.free(toPos);
        SolMath.fromAl(velocity, fromPlanetAngle + 90.0f, hSpeed);
        velocity.add(this.velocity);
    }

    public float getAtmosphereDamagePerSecond() {
        return this.atmosphereDamagePerSecond;
    }

    public float getGroundDamagePerSecond() {
        return this.groundDamagePerSecond;
    }
}

