/*
 * Decompiled with CFR 0.152.
 */
package org.destinationsol.game.planet;

import com.badlogic.gdx.math.Vector2;
import org.destinationsol.common.SolMath;
import org.destinationsol.game.SolGame;
import org.destinationsol.game.planet.Planet;

public class PlanetBind {
    private final Planet planet;
    private final Vector2 relativePosition;
    private final float relativeAngle;

    private PlanetBind(Planet planet, Vector2 position, float angle) {
        this.planet = planet;
        this.relativePosition = new Vector2();
        float planetAngle = planet.getAngle();
        SolMath.toRel(position, this.relativePosition, planetAngle, planet.getPosition());
        this.relativeAngle = angle - planetAngle;
    }

    public static PlanetBind tryBind(SolGame game, Vector2 position, float angle) {
        Planet planet = game.getPlanetManager().getNearestPlanet(position);
        if (!planet.isNearGround(position)) {
            return null;
        }
        return new PlanetBind(planet, position, angle);
    }

    public void setDiff(Vector2 diff, Vector2 position, boolean precise) {
        SolMath.toWorld(diff, this.relativePosition, this.planet.getAngle(), this.planet.getPosition());
        diff.sub(position);
    }

    public float getDesiredAngle() {
        return this.planet.getAngle() + this.relativeAngle;
    }

    public Planet getPlanet() {
        return this.planet;
    }
}

