/*
 * Decompiled with CFR 0.152.
 */
package org.destinationsol.game.planet;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.destinationsol.assets.Assets;
import org.destinationsol.assets.json.Json;
import org.destinationsol.assets.json.Validator;
import org.destinationsol.common.SolRandom;
import org.destinationsol.files.HullConfigManager;
import org.destinationsol.game.GameColors;
import org.destinationsol.game.item.ItemManager;
import org.destinationsol.game.planet.PlanetConfig;
import org.json.JSONObject;
import org.terasology.gestalt.assets.ResourceUrn;

public class PlanetConfigs {
    private final Map<String, PlanetConfig> allConfigs = new HashMap<String, PlanetConfig>();
    private final List<PlanetConfig> easy = new ArrayList<PlanetConfig>();
    private final List<PlanetConfig> medium = new ArrayList<PlanetConfig>();
    private final List<PlanetConfig> hard = new ArrayList<PlanetConfig>();

    public PlanetConfigs(HullConfigManager hullConfigs, GameColors cols, ItemManager itemManager) {
        Set<ResourceUrn> planetJsonConfigs = Assets.getAssetHelper().listAssets(Json.class, "planetsConfig");
        for (ResourceUrn planetConfigJson : planetJsonConfigs) {
            String moduleName = planetConfigJson.getModuleName().toString();
            JSONObject rootNode = Validator.getValidatedJSON(planetConfigJson.toString(), "engine:schemaPlanetsConfig");
            for (String s : rootNode.keySet()) {
                JSONObject node = rootNode.getJSONObject(s);
                PlanetConfig planetConfig = PlanetConfig.load(s, node, hullConfigs, cols, itemManager, moduleName);
                this.allConfigs.put(s, planetConfig);
                if (planetConfig.hardOnly) {
                    this.hard.add(planetConfig);
                    continue;
                }
                if (planetConfig.easyOnly) {
                    this.easy.add(planetConfig);
                    continue;
                }
                this.medium.add(planetConfig);
            }
        }
    }

    public PlanetConfig getConfig(String name) {
        return this.allConfigs.get(name);
    }

    public PlanetConfig getRandom(boolean easy, boolean hard) {
        List<PlanetConfig> cfg = easy ? this.easy : (hard ? this.hard : this.medium);
        return SolRandom.seededRandomElement(cfg);
    }

    public Map<String, PlanetConfig> getAllConfigs() {
        return this.allConfigs;
    }
}

