/*
 * Decompiled with CFR 0.152.
 */
package org.destinationsol.game.planet;

import com.badlogic.gdx.graphics.g2d.TextureAtlas;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.math.Vector2;
import org.destinationsol.assets.Assets;
import org.destinationsol.common.SolColor;
import org.destinationsol.game.GameDrawer;
import org.destinationsol.game.SolCam;
import org.destinationsol.game.SolGame;
import org.destinationsol.game.planet.Planet;

public class PlanetCoreSingleton {
    private final TextureAtlas.AtlasRegion texture = Assets.getAtlasRegion("engine:planetStarCommonPlanetCore");

    PlanetCoreSingleton() {
    }

    public void draw(SolGame game, GameDrawer drawer) {
        SolCam cam = game.getCam();
        Vector2 camPosition = cam.getPosition();
        Planet nearestPlanet = game.getPlanetManager().getNearestPlanet();
        Vector2 planetPosition = nearestPlanet.getPosition();
        float distanceToCam = camPosition.dst(planetPosition);
        float viewDistance = cam.getViewDistance();
        float minGroundHeight = nearestPlanet.getMinGroundHeight();
        if (distanceToCam < minGroundHeight + viewDistance) {
            drawer.draw((TextureRegion)this.texture, minGroundHeight * 2.0f, minGroundHeight * 2.0f, minGroundHeight, minGroundHeight, planetPosition.x, planetPosition.y, nearestPlanet.getAngle(), SolColor.WHITE);
        }
    }
}

