/*
 * Decompiled with CFR 0.152.
 */
package org.destinationsol.game.planet;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.physics.box2d.Body;
import java.util.ArrayList;
import java.util.List;
import org.destinationsol.common.SolColor;
import org.destinationsol.common.SolMath;
import org.destinationsol.files.HullConfigManager;
import org.destinationsol.game.DebugOptions;
import org.destinationsol.game.GameColors;
import org.destinationsol.game.GameDrawer;
import org.destinationsol.game.SolCam;
import org.destinationsol.game.SolGame;
import org.destinationsol.game.SolNames;
import org.destinationsol.game.SolObject;
import org.destinationsol.game.UpdateAwareSystem;
import org.destinationsol.game.item.ItemManager;
import org.destinationsol.game.maze.Maze;
import org.destinationsol.game.maze.MazeConfigs;
import org.destinationsol.game.planet.ConsumedAngles;
import org.destinationsol.game.planet.FlatPlaceFinder;
import org.destinationsol.game.planet.Planet;
import org.destinationsol.game.planet.PlanetConfigs;
import org.destinationsol.game.planet.PlanetCoreSingleton;
import org.destinationsol.game.planet.SolSystem;
import org.destinationsol.game.planet.SunSingleton;
import org.destinationsol.game.planet.SysConfigs;
import org.destinationsol.game.planet.SystemBelt;
import org.destinationsol.game.planet.SystemsBuilder;
import org.destinationsol.game.ship.SolShip;
import org.destinationsol.game.ship.hulls.Hull;
import org.destinationsol.game.ship.hulls.HullConfig;

public class PlanetManager
implements UpdateAwareSystem {
    private final ArrayList<SolSystem> systems;
    private final ArrayList<Planet> planets;
    private final ArrayList<SystemBelt> belts;
    private final FlatPlaceFinder flatPlaceFinder;
    private final PlanetConfigs planetConfigs;
    private final MazeConfigs mazeConfigs;
    private final ArrayList<Maze> mazes;
    private final SunSingleton sunSingleton;
    private final SysConfigs sysConfigs;
    private final PlanetCoreSingleton planetCoreSingleton;
    private Planet nearestPlanet;

    public PlanetManager(HullConfigManager hullConfigs, GameColors cols, ItemManager itemManager) {
        this.planetConfigs = new PlanetConfigs(hullConfigs, cols, itemManager);
        this.sysConfigs = new SysConfigs(hullConfigs, itemManager);
        this.mazeConfigs = new MazeConfigs(hullConfigs, itemManager);
        this.systems = new ArrayList();
        this.mazes = new ArrayList();
        this.planets = new ArrayList();
        this.belts = new ArrayList();
        this.flatPlaceFinder = new FlatPlaceFinder();
        this.sunSingleton = new SunSingleton();
        this.planetCoreSingleton = new PlanetCoreSingleton();
    }

    public void fill(SolNames names, int numberOfSystems) {
        new SystemsBuilder().build(this.systems, this.planets, this.belts, this.planetConfigs, this.mazeConfigs, this.mazes, this.sysConfigs, names, numberOfSystems);
    }

    @Override
    public void update(SolGame game, float timeStep) {
        Vector2 camPos = game.getCam().getPosition();
        for (Planet planet : this.planets) {
            planet.update(game, timeStep);
        }
        for (Maze maze : this.mazes) {
            maze.update(game);
        }
        this.nearestPlanet = this.getNearestPlanet(camPos);
        SolSystem nearestSys = this.getNearestSystem(camPos);
        this.applyGrav(game, nearestSys);
    }

    public Planet getNearestPlanet(Vector2 position) {
        float minDst = Float.MAX_VALUE;
        Planet res = null;
        for (Planet planet : this.planets) {
            float dst = position.dst(planet.getPosition());
            if (!(dst < minDst)) continue;
            minDst = dst;
            res = planet;
        }
        return res;
    }

    private void applyGrav(SolGame game, SolSystem nearestSys) {
        float npGh = this.nearestPlanet.getGroundHeight();
        float npFh = this.nearestPlanet.getFullHeight();
        float npMinH = this.nearestPlanet.getMinGroundHeight();
        Vector2 npPos = this.nearestPlanet.getPosition();
        Vector2 sysPos = nearestSys.getPosition();
        float npGravConst = this.nearestPlanet.getGravitationConstant();
        List<SolObject> objs = game.getObjectManager().getObjects();
        for (SolObject obj : objs) {
            boolean onPlanet;
            float gravConst;
            Vector2 srcPos;
            float minDist;
            if (!obj.receivesGravity()) continue;
            Vector2 objPos = obj.getPosition();
            float toNp = npPos.dst(objPos);
            float toSys = sysPos.dst(objPos);
            if (toNp < npFh) {
                if (this.recoverObj(obj, toNp, npMinH)) continue;
                minDist = npGh;
                srcPos = npPos;
                gravConst = npGravConst;
                onPlanet = true;
            } else {
                if (!(toSys < 78.0f)) continue;
                minDist = 58.5f;
                srcPos = sysPos;
                gravConst = 2000.0f;
                onPlanet = false;
            }
            Vector2 grav = SolMath.getVec(srcPos);
            grav.sub(objPos);
            float len = grav.len();
            grav.nor();
            if (len < minDist) {
                len = minDist;
            }
            float g = gravConst / len / len;
            grav.scl(g);
            obj.receiveForce(grav, game, true);
            SolMath.free(grav);
            if (onPlanet) continue;
            this.sunSingleton.doDmg(game, obj, toSys);
        }
    }

    private boolean recoverObj(SolObject obj, float toNp, float npMinH) {
        if (npMinH < toNp) {
            return false;
        }
        if (!(obj instanceof SolShip)) {
            return false;
        }
        SolShip ship = (SolShip)obj;
        Hull hull = ship.getHull();
        if (hull.config.getType() == HullConfig.Type.STATION) {
            return false;
        }
        float fh = this.nearestPlanet.getFullHeight();
        Vector2 npPos = this.nearestPlanet.getPosition();
        Vector2 toShip = SolMath.distVec(npPos, ship.getPosition());
        float len = toShip.len();
        if (len == 0.0f) {
            toShip.set(0.0f, fh);
        } else {
            toShip.scl(fh / len);
        }
        toShip.add(npPos);
        Body body = hull.getBody();
        body.setTransform(toShip, 0.0f);
        body.setLinearVelocity(Vector2.Zero);
        SolMath.free(toShip);
        return true;
    }

    public Planet getNearestPlanet() {
        return this.nearestPlanet;
    }

    public void drawDebug(GameDrawer drawer, SolGame game) {
        if (DebugOptions.DRAW_PLANET_BORDERS) {
            SolCam cam = game.getCam();
            float lineWidth = cam.getRealLineWidth();
            float viewHeight = cam.getViewHeight();
            for (Planet planet : this.planets) {
                Vector2 position = planet.getPosition();
                float angle = planet.getAngle();
                float fullHeight = planet.getFullHeight();
                Color color = planet == this.nearestPlanet ? SolColor.WHITE : SolColor.G;
                drawer.drawCircle((TextureRegion)drawer.debugWhiteTexture, position, planet.getGroundHeight(), color, lineWidth, viewHeight);
                drawer.drawCircle((TextureRegion)drawer.debugWhiteTexture, position, fullHeight, color, lineWidth, viewHeight);
                drawer.drawLine((TextureRegion)drawer.debugWhiteTexture, position.x, position.y, angle, fullHeight, color, lineWidth);
            }
        }
    }

    public ArrayList<Planet> getPlanets() {
        return this.planets;
    }

    public ArrayList<SystemBelt> getBelts() {
        return this.belts;
    }

    public ArrayList<SolSystem> getSystems() {
        return this.systems;
    }

    public Vector2 findFlatPlace(SolGame game, Planet planet, ConsumedAngles takenAngles, float objHalfWidth) {
        return this.flatPlaceFinder.find(game, planet, takenAngles, objHalfWidth);
    }

    public ArrayList<Maze> getMazes() {
        return this.mazes;
    }

    public SolSystem getNearestSystem(Vector2 position) {
        float minDst = Float.MAX_VALUE;
        SolSystem res = null;
        for (SolSystem system : this.systems) {
            float dst = position.dst(system.getPosition());
            if (!(dst < minDst)) continue;
            minDst = dst;
            res = system;
        }
        return res;
    }

    public Maze getNearestMaze(Vector2 position) {
        float minDst = Float.MAX_VALUE;
        Maze res = null;
        for (Maze maze : this.mazes) {
            float dst = position.dst(maze.getPos());
            if (!(dst < minDst)) continue;
            minDst = dst;
            res = maze;
        }
        return res;
    }

    public void drawSunHack(SolGame game, GameDrawer drawer) {
        this.sunSingleton.draw(game, drawer);
    }

    public void drawPlanetCoreHack(SolGame game, GameDrawer drawer) {
        this.planetCoreSingleton.draw(game, drawer);
    }
}

