/*
 * Decompiled with CFR 0.152.
 */
package org.destinationsol.game.planet;

import com.badlogic.gdx.graphics.g2d.TextureAtlas;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.physics.box2d.RayCastCallback;
import com.badlogic.gdx.physics.box2d.World;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.destinationsol.common.SolColor;
import org.destinationsol.common.SolMath;
import org.destinationsol.common.SolRandom;
import org.destinationsol.game.DebugOptions;
import org.destinationsol.game.Faction;
import org.destinationsol.game.ShipConfig;
import org.destinationsol.game.SolGame;
import org.destinationsol.game.drawables.Drawable;
import org.destinationsol.game.drawables.DrawableLevel;
import org.destinationsol.game.drawables.RectSprite;
import org.destinationsol.game.drawables.SpriteManager;
import org.destinationsol.game.input.AiPilot;
import org.destinationsol.game.input.OrbiterDestProvider;
import org.destinationsol.game.input.StillGuard;
import org.destinationsol.game.item.TradeConfig;
import org.destinationsol.game.planet.ConsumedAngles;
import org.destinationsol.game.planet.DecoConfig;
import org.destinationsol.game.planet.FarPlanetSprites;
import org.destinationsol.game.planet.FarTileObject;
import org.destinationsol.game.planet.GroundBuilder;
import org.destinationsol.game.planet.Planet;
import org.destinationsol.game.planet.PlanetConfig;
import org.destinationsol.game.planet.Sky;
import org.destinationsol.game.planet.Tile;
import org.destinationsol.game.planet.TileObjBuilder;
import org.destinationsol.game.planet.TileObject;
import org.destinationsol.game.ship.FarShip;
import org.destinationsol.game.ship.hulls.HullConfig;

public class PlanetObjectsBuilder {
    private static final float TOP_TILE_SZ = 2.0f;
    private static final float MAX_CLOUD_PIECE_SZ = 1.5f;
    private static final float MAX_CLOUT_PIECE_ROT_SPD = 5.0f;
    private static final int MAX_CLOUD_PIECE_COUNT = 30;
    private static final float MAX_CLOUD_PIECE_DIST_SHIFT = 1.0f;
    private static final float MAX_CLOUD_LINEAR_SPD = 0.1f;
    private static final float AVG_CLOUD_LINEAR_WIDTH = 3.0f;
    private static final float CLOUD_DENSITY = 0.2f;
    private static final float DECO_PACK_SZ = 5.0f;
    private static final float DECO_PACK_ANGULAR_WIDTH = 11.459156f;

    public float createPlanetObjs(SolGame game, Planet planet) {
        if (DebugOptions.NO_OBJS) {
            return 0.0f;
        }
        float minRadius = this.createGround(game, planet);
        this.createClouds(game, planet);
        this.createDecorations(game, planet);
        if (planet.getConfig().skyConfig != null) {
            Sky sky = new Sky(game, planet);
            game.getObjectManager().addObjDelayed(sky);
        }
        this.createShips(game, planet);
        return minRadius;
    }

    private void createShips(SolGame game, Planet planet) {
        ConsumedAngles takenAngles = new ConsumedAngles();
        ShipConfig stationConfig = planet.getConfig().stationConfig;
        if (stationConfig != null) {
            FarShip station = this.buildGroundShip(game, planet, stationConfig, planet.getConfig().tradeConfig, Faction.LAANI, takenAngles, "Station");
            game.getObjectManager().addFarObjNow(station);
        }
        float groundHeight = planet.getGroundHeight();
        PlanetConfig config = planet.getConfig();
        for (ShipConfig groundEnemy : config.groundEnemies) {
            int count = (int)(groundEnemy.density * groundHeight);
            for (int i = 0; i < count; ++i) {
                FarShip enemy = this.buildGroundShip(game, planet, groundEnemy, null, Faction.EHAR, takenAngles, null);
                game.getObjectManager().addFarObjNow(enemy);
            }
        }
        this.buildOrbitEnemies(game, planet, groundHeight, 0.0f, 0.1f, config.lowOrbitEnemies, 3.6000001f);
        this.buildOrbitEnemies(game, planet, groundHeight, 0.1f, 0.6f, config.highOrbitEnemies, 5.4f);
    }

    private void buildOrbitEnemies(SolGame game, Planet planet, float groundHeight, float offsetPercentage, float atmPercentage, List<ShipConfig> configs, float detDist) {
        if (configs.isEmpty()) {
            return;
        }
        HashMap<ShipConfig, Integer> counts = new HashMap<ShipConfig, Integer>();
        int totalCount = 0;
        for (ShipConfig oe : configs) {
            int count = (int)(atmPercentage * oe.density * groundHeight * 14.0f);
            counts.put(oe, count);
            totalCount += count;
        }
        float stepPercentage = atmPercentage / (float)totalCount;
        float heightPercentage = offsetPercentage;
        for (ShipConfig shipConfig : configs) {
            int count = (Integer)counts.get(shipConfig);
            for (int i = 0; i < count; ++i) {
                FarShip enemy = this.buildOrbitEnemy(game, planet, heightPercentage, shipConfig, detDist);
                game.getObjectManager().addFarObjNow(enemy);
                heightPercentage += stepPercentage;
            }
        }
    }

    private float createGround(SolGame game, Planet planet) {
        float maxRadius = planet.getGroundHeight() - 1.0f;
        int columns = (int)((float)Math.PI * 2 * maxRadius / 2.0f);
        if (columns <= 0) {
            throw new AssertionError((Object)"Error creating planet ground!");
        }
        int rows = planet.getConfig().rowCount;
        float[] radii = new float[rows];
        float[] tileSizes = new float[rows];
        float currentRadius = maxRadius;
        for (int row = 0; row < rows; ++row) {
            float tileSize = (float)Math.PI * 2 * currentRadius / (float)columns;
            radii[row] = currentRadius;
            tileSizes[row] = tileSize;
            currentRadius -= tileSize;
        }
        float minRadius = radii[rows - 1] - tileSizes[rows - 1] / 2.0f;
        Tile[][] tileMap = new GroundBuilder(planet.getConfig(), columns, rows).build();
        for (int row = 0; row < rows; ++row) {
            float tileDistance = radii[row];
            float tileSize = tileSizes[row];
            for (int col = 0; col < columns; ++col) {
                Tile tile = tileMap[col][row];
                if (tile == null) continue;
                float toPlanetRelAngle = 360.0f * (float)col / (float)columns;
                if (tile.points.isEmpty()) {
                    FarTileObject farTileObject = new FarTileObject(planet, toPlanetRelAngle, tileDistance, tileSize, tile);
                    game.getObjectManager().addFarObjNow(farTileObject);
                    continue;
                }
                TileObject tileObject = new TileObjBuilder().build(game, tileSize, toPlanetRelAngle, tileDistance, tile, planet);
                game.getObjectManager().addObjNow(game, tileObject);
            }
        }
        return minRadius;
    }

    private void createClouds(SolGame game, Planet planet) {
        List<TextureAtlas.AtlasRegion> cloudTextures = planet.getConfig().cloudTextures;
        if (cloudTextures.isEmpty()) {
            return;
        }
        int cloudCount = SolRandom.randomInt(0.7f, (int)(2.8f * planet.getGroundHeight()));
        for (int i = 0; i < cloudCount; ++i) {
            FarPlanetSprites cloud = this.createCloud(planet, cloudTextures);
            game.getObjectManager().addFarObjNow(cloud);
        }
    }

    private FarPlanetSprites createCloud(Planet planet, List<TextureAtlas.AtlasRegion> cloudTextures) {
        float distancePercentage = SolRandom.randomFloat(0.0f, 1.0f);
        float distance = planet.getGroundHeight() - 2.0f + 12.599999f * distancePercentage;
        float angle = SolRandom.randomFloat(180.0f);
        ArrayList<Drawable> drawables = new ArrayList<Drawable>();
        float sizePercentage = SolRandom.randomFloat(0.2f, 1.0f);
        float linearWidth = sizePercentage * (distancePercentage + 0.5f) * 3.0f;
        float maxAngleShift = SolMath.arcToAngle(linearWidth, distance);
        float maxDistanceShift = (1.0f - distancePercentage) * 1.0f;
        int pieceCount = (int)(sizePercentage * 30.0f);
        for (int i = 0; i < pieceCount; ++i) {
            RectSprite cloudSprite = this.createCloudSprite(cloudTextures, maxAngleShift, maxDistanceShift, distance);
            drawables.add(cloudSprite);
        }
        float rotationSpeed = SolRandom.randomFloat(0.1f, 1.0f) * SolMath.arcToAngle(0.1f, distance);
        return new FarPlanetSprites(planet, angle, distance, drawables, rotationSpeed);
    }

    private RectSprite createCloudSprite(List<TextureAtlas.AtlasRegion> cloudTextures, float maxAngleShift, float maxDistanceShift, float baseDistance) {
        TextureAtlas.AtlasRegion texture = new TextureAtlas.AtlasRegion(SolRandom.randomElement(cloudTextures));
        if (SolRandom.test(0.5f)) {
            texture.flip(!texture.isFlipX(), !texture.isFlipY());
        }
        float relativeAngleShift = SolRandom.randomFloat(1.0f);
        float distancePercentage = 1.0f - SolMath.abs(relativeAngleShift);
        float size = 0.5f * (1.0f + distancePercentage) * 1.5f;
        float relativeAngle = SolRandom.randomFloat(30.0f);
        float rotationSpeed = SolRandom.randomFloat(5.0f);
        float angleShift = relativeAngleShift * maxAngleShift;
        float distanceShift = maxDistanceShift == 0.0f ? 0.0f : distancePercentage * SolRandom.randomFloat(0.0f, maxDistanceShift);
        float distance = baseDistance + distanceShift;
        Vector2 basePosition = SolMath.getVec(0.0f, -baseDistance);
        Vector2 relativePosition = new Vector2(0.0f, -distance);
        SolMath.rotate(relativePosition, angleShift);
        relativePosition.sub(basePosition);
        SolMath.free(basePosition);
        return SpriteManager.createSprite(texture.name, size, 0.0f, 0.0f, relativePosition, DrawableLevel.CLOUDS, relativeAngle, rotationSpeed, SolColor.WHITE, false);
    }

    private void createDecorations(SolGame game, Planet planet) {
        float groundHeight = planet.getGroundHeight();
        Vector2 planetPos = planet.getPosition();
        float planetAngle = planet.getAngle();
        HashMap<Vector2, List<Drawable>> collector = new HashMap<Vector2, List<Drawable>>();
        PlanetConfig config = planet.getConfig();
        for (DecoConfig decoConfig : config.deco) {
            this.addDeco(game, groundHeight, planetPos, collector, decoConfig);
        }
        for (Map.Entry entry : collector.entrySet()) {
            Vector2 position = (Vector2)entry.getKey();
            List drawables = (List)entry.getValue();
            float angle = SolMath.angle(planetPos, position) - planetAngle;
            float distance = position.dst(planetPos);
            FarPlanetSprites planetSprites = new FarPlanetSprites(planet, angle, distance, drawables, 0.0f);
            game.getObjectManager().addFarObjNow(planetSprites);
        }
    }

    private void addDeco(SolGame game, float groundHeight, Vector2 planetPos, Map<Vector2, List<Drawable>> collector, DecoConfig decoConfig) {
        World world = game.getObjectManager().getWorld();
        ConsumedAngles consumed = new ConsumedAngles();
        Vector2 rayCasted = new Vector2();
        RayCastCallback rayCastCallback = (fixture, point, normal, fraction) -> {
            if (!(fixture.getBody().getUserData() instanceof TileObject)) {
                return -1.0f;
            }
            rayCasted.set(point);
            return fraction;
        };
        int decorationCount = (int)((float)Math.PI * 2 * groundHeight * decoConfig.density);
        for (int i = 0; i < decorationCount; ++i) {
            float decorationSize = SolRandom.randomFloat(decoConfig.szMin, decoConfig.szMax);
            float angularHalfWidth = SolMath.angularWidthOfSphere(decorationSize / 2.0f, groundHeight);
            float decorationAngle = 0.0f;
            for (int j = 0; j < 5; ++j) {
                decorationAngle = SolRandom.randomFloat(180.0f);
                if (consumed.isConsumed(decorationAngle, angularHalfWidth)) continue;
                consumed.add(decorationAngle, angularHalfWidth);
                break;
            }
            SolMath.fromAl(rayCasted, decorationAngle, groundHeight);
            rayCasted.add(planetPos);
            world.rayCast(rayCastCallback, rayCasted, planetPos);
            float decorationDistance = rayCasted.dst(planetPos);
            float baseAngle = SolMath.windowCenter(decorationAngle, 11.459156f);
            float baseDistance = SolMath.windowCenter(decorationDistance, 5.0f);
            Vector2 basePosition = SolMath.fromAl(baseAngle, baseDistance).add(planetPos);
            Vector2 decoRelativePosition = new Vector2(rayCasted).sub(basePosition);
            SolMath.rotate(decoRelativePosition, -baseAngle - 90.0f);
            float decorationRelativeAngle = decorationAngle - baseAngle;
            TextureAtlas.AtlasRegion decorationTexture = new TextureAtlas.AtlasRegion(SolRandom.randomElement(decoConfig.texs));
            if (decoConfig.allowFlip && SolRandom.test(0.5f)) {
                decorationTexture.flip(!decorationTexture.isFlipX(), !decorationTexture.isFlipY());
            }
            RectSprite sprite = SpriteManager.createSprite(decorationTexture.name, decorationSize, decoConfig.orig.x, decoConfig.orig.y, decoRelativePosition, DrawableLevel.DECO, decorationRelativeAngle, 0.0f, SolColor.WHITE, false);
            List<Drawable> drawables = collector.get(basePosition);
            if (drawables == null) {
                drawables = new ArrayList<Drawable>();
                collector.put(new Vector2(basePosition), drawables);
            }
            drawables.add(sprite);
            SolMath.free(basePosition);
        }
    }

    private FarShip buildGroundShip(SolGame game, Planet planet, ShipConfig shipConfig, TradeConfig tradeConfig, Faction faction, ConsumedAngles takenAngles, String mapHint) {
        Vector2 position = game.getPlanetManager().findFlatPlace(game, planet, takenAngles, shipConfig.hull.getApproxRadius());
        boolean station = shipConfig.hull.getType() == HullConfig.Type.STATION;
        String shipItems = shipConfig.items;
        boolean hasRepairer = faction == Faction.LAANI;
        int money = shipConfig.money;
        float height = position.len();
        float aboveGround = station ? shipConfig.hull.getSize() * 0.75f - shipConfig.hull.getOrigin().y : shipConfig.hull.getSize();
        position.scl((height + aboveGround) / height);
        SolMath.toWorld(position, position, planet.getAngle(), planet.getPosition());
        Vector2 distanceToPlanet = SolMath.getVec(planet.getPosition()).sub(position);
        float angle = SolMath.angle(distanceToPlanet) - 180.0f;
        if (station) {
            angle += 90.0f;
        }
        Vector2 velocity = new Vector2(distanceToPlanet).nor();
        SolMath.free(distanceToPlanet);
        AiPilot provider = new AiPilot(new StillGuard(position, game, shipConfig), false, faction, true, mapHint, 5.4f);
        return game.getShipBuilder().buildNewFar(game, position, velocity, angle, 0.0f, provider, shipItems, shipConfig.hull, null, hasRepairer, money, tradeConfig, true);
    }

    private FarShip buildOrbitEnemy(SolGame game, Planet planet, float heightPercentage, ShipConfig shipConfig, float detectionDistance) {
        float height = planet.getGroundHeight() + heightPercentage * 14.0f;
        Vector2 position = new Vector2();
        SolMath.fromAl(position, SolRandom.randomFloat(180.0f), height);
        Vector2 planetPosition = planet.getPosition();
        position.add(planetPosition);
        float speed = SolMath.sqrt(planet.getGravitationConstant() / height);
        boolean clockwise = SolRandom.test(0.5f);
        if (!clockwise) {
            speed *= -1.0f;
        }
        Vector2 velocity = new Vector2(0.0f, -speed);
        Vector2 directionToPlanet = SolMath.distVec(position, planetPosition);
        SolMath.rotate(velocity, SolMath.angle(directionToPlanet));
        SolMath.free(directionToPlanet);
        OrbiterDestProvider destProvider = new OrbiterDestProvider(planet, height, clockwise);
        AiPilot provider = new AiPilot(destProvider, false, Faction.EHAR, true, null, detectionDistance);
        int money = shipConfig.money;
        return game.getShipBuilder().buildNewFar(game, position, velocity, 0.0f, 0.0f, provider, shipConfig.items, shipConfig.hull, null, false, money, null, true);
    }
}

