/*
 * Decompiled with CFR 0.152.
 */
package org.destinationsol.game.planet;

import com.badlogic.gdx.math.Vector2;
import java.util.List;
import org.destinationsol.common.SolMath;
import org.destinationsol.game.DmgType;
import org.destinationsol.game.FarObject;
import org.destinationsol.game.SolGame;
import org.destinationsol.game.SolObject;
import org.destinationsol.game.drawables.Drawable;
import org.destinationsol.game.planet.FarPlanetSprites;
import org.destinationsol.game.planet.Planet;

public class PlanetSprites
implements SolObject {
    private final Planet planet;
    private final float distance;
    private final List<Drawable> drawables;
    private final float RotationSpeedToPlanet;
    private final Vector2 position;
    private float relativeAngleToPlanet;
    private float angle;

    PlanetSprites(Planet planet, float relAngleToPlanet, float dist, List<Drawable> drawables, float toPlanetRotationSpeed) {
        this.planet = planet;
        this.relativeAngleToPlanet = relAngleToPlanet;
        this.distance = dist;
        this.drawables = drawables;
        this.RotationSpeedToPlanet = toPlanetRotationSpeed;
        this.position = new Vector2();
        this.setDependentParams();
    }

    @Override
    public void update(SolGame game) {
        this.setDependentParams();
        this.relativeAngleToPlanet += this.RotationSpeedToPlanet * game.getTimeStep();
    }

    private void setDependentParams() {
        float angleToPlanet = this.planet.getAngle() + this.relativeAngleToPlanet;
        SolMath.fromAl(this.position, angleToPlanet, this.distance);
        this.position.add(this.planet.getPosition());
        this.angle = angleToPlanet + 90.0f;
    }

    @Override
    public boolean shouldBeRemoved(SolGame game) {
        return false;
    }

    @Override
    public void onRemove(SolGame game) {
    }

    @Override
    public void receiveDmg(float dmg, SolGame game, Vector2 position, DmgType dmgType) {
    }

    @Override
    public boolean receivesGravity() {
        return false;
    }

    @Override
    public void receiveForce(Vector2 force, SolGame game, boolean acc) {
    }

    @Override
    public Vector2 getPosition() {
        return this.position;
    }

    @Override
    public FarObject toFarObject() {
        return new FarPlanetSprites(this.planet, this.relativeAngleToPlanet, this.distance, this.drawables, this.RotationSpeedToPlanet);
    }

    @Override
    public List<Drawable> getDrawables() {
        return this.drawables;
    }

    @Override
    public float getAngle() {
        return this.angle;
    }

    @Override
    public Vector2 getVelocity() {
        return null;
    }

    @Override
    public void handleContact(SolObject other, float absImpulse, SolGame game, Vector2 collPos) {
    }

    @Override
    public String toDebugString() {
        return null;
    }

    @Override
    public Boolean isMetal() {
        return false;
    }

    @Override
    public boolean hasBody() {
        return false;
    }
}

