/*
 * Decompiled with CFR 0.152.
 */
package org.destinationsol.game.planet;

import com.badlogic.gdx.graphics.g2d.Animation;
import com.badlogic.gdx.graphics.g2d.TextureAtlas;
import com.badlogic.gdx.math.Vector2;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.destinationsol.assets.Assets;
import org.destinationsol.common.SolRandom;
import org.destinationsol.game.CollisionMeshLoader;
import org.destinationsol.game.DebugOptions;
import org.destinationsol.game.drawables.SpriteInfo;
import org.destinationsol.game.planet.SurfaceDirection;
import org.destinationsol.game.planet.Tile;

public class PlanetTiles {
    private final Map<SurfaceDirection, Map<SurfaceDirection, List<Tile>>> groundTiles = new HashMap<SurfaceDirection, Map<SurfaceDirection, List<Tile>>>();

    PlanetTiles(String groundName) {
        this.loadGround(groundName);
    }

    private void loadGround(String groundName) {
        CollisionMeshLoader collisionMeshLoader = new CollisionMeshLoader(groundName);
        CollisionMeshLoader.Model paths = collisionMeshLoader.getInternalModel();
        for (SurfaceDirection from : SurfaceDirection.values()) {
            HashMap<SurfaceDirection, ArrayList<Tile>> fromMap = new HashMap<SurfaceDirection, ArrayList<Tile>>();
            this.groundTiles.put(from, fromMap);
            for (SurfaceDirection to : SurfaceDirection.values()) {
                if (from == SurfaceDirection.DOWN && to == SurfaceDirection.DOWN) continue;
                boolean inverted = from == SurfaceDirection.DOWN || to == SurfaceDirection.UP;
                String fromL = from.getLetter();
                String toL = to.getLetter();
                String tileDescName = inverted ? toL + fromL : fromL + toL;
                String tileVariant = groundName + "_" + tileDescName;
                List<TextureAtlas.AtlasRegion> texs = Assets.listTexturesMatching(tileVariant + "_.*");
                ArrayList<Tile> tileVariants = this.buildTiles(paths, inverted, tileDescName, from, to, texs);
                fromMap.put(to, tileVariants);
            }
        }
    }

    private ArrayList<Tile> buildTiles(CollisionMeshLoader.Model paths, boolean inverted, String tileDescName, SurfaceDirection from, SurfaceDirection to, List<TextureAtlas.AtlasRegion> texs) {
        ArrayList<Tile> tileVariants = new ArrayList<Tile>();
        for (TextureAtlas.AtlasRegion tex : texs) {
            List<CollisionMeshLoader.PolygonModel> shapes;
            if (inverted) {
                tex.flip(!tex.isFlipX(), !tex.isFlipY());
            }
            String tileName = tileDescName + "_" + tex.name.substring(tex.name.lastIndexOf(95) + 1) + ".png";
            ArrayList<Vector2> points = new ArrayList<Vector2>();
            CollisionMeshLoader.RigidBodyModel tilePaths = paths == null ? null : paths.rigidBodies.get(tileName);
            List<CollisionMeshLoader.PolygonModel> list = shapes = tilePaths == null ? null : tilePaths.shapes;
            List<Vector2> rawPoints = shapes != null && !shapes.isEmpty() ? shapes.get((int)0).vertices : this.getDefaultRawPoints(inverted ? to : from, inverted ? from : to, tileName);
            int sz = rawPoints.size();
            for (int j = 0; j < sz; ++j) {
                TextureAtlas.AtlasRegion[] v = rawPoints.get(inverted ? sz - j - 1 : j);
                Vector2 point = new Vector2(v.x - 0.5f, v.y - 0.5f);
                if (inverted) {
                    point.x *= -1.0f;
                }
                points.add(point);
            }
            Animation<TextureAtlas.AtlasRegion> animation = Assets.getAnimation(tex.name);
            for (TextureAtlas.AtlasRegion texture : (TextureAtlas.AtlasRegion[])animation.getKeyFrames()) {
                texture.flip(tex.isFlipX() && !texture.isFlipX(), tex.isFlipY() && !texture.isFlipY());
            }
            SpriteInfo sprite = new SpriteInfo(tex.name, animation);
            tileVariants.add(new Tile(sprite, points, from, to));
        }
        return tileVariants;
    }

    private List<Vector2> getDefaultRawPoints(SurfaceDirection from, SurfaceDirection to, String tileName) {
        ArrayList<Vector2> result = new ArrayList<Vector2>();
        if (from == SurfaceDirection.UP && to == SurfaceDirection.UP) {
            return result;
        }
        DebugOptions.MISSING_PHYSICS_ACTION.handle("no path found for " + tileName);
        result.add(new Vector2(0.25f, 0.75f));
        if (from == SurfaceDirection.FWD) {
            result.add(new Vector2(0.25f, 0.5f));
        } else {
            result.add(new Vector2(0.25f, 0.25f));
            result.add(new Vector2(0.5f, 0.25f));
        }
        result.add(new Vector2(0.5f, 0.5f));
        if (to == SurfaceDirection.FWD) {
            result.add(new Vector2(0.75f, 0.5f));
            result.add(new Vector2(0.75f, 0.75f));
        } else {
            result.add(new Vector2(0.5f, 0.75f));
        }
        return result;
    }

    public Tile getGround(SurfaceDirection from, SurfaceDirection to) {
        List<Tile> list = this.groundTiles.get((Object)from).get((Object)to);
        return SolRandom.randomElement(list);
    }

    public Tile getDungeonEntrance(boolean down, boolean left, boolean right) {
        return null;
    }
}

