/*
 * Decompiled with CFR 0.152.
 */
package org.destinationsol.game.planet;

import com.badlogic.gdx.math.Vector2;
import java.util.ArrayList;
import java.util.List;
import org.destinationsol.common.SolColor;
import org.destinationsol.common.SolMath;
import org.destinationsol.game.ColorSpan;
import org.destinationsol.game.DmgType;
import org.destinationsol.game.FarObject;
import org.destinationsol.game.SolCam;
import org.destinationsol.game.SolGame;
import org.destinationsol.game.SolObject;
import org.destinationsol.game.drawables.Drawable;
import org.destinationsol.game.drawables.DrawableLevel;
import org.destinationsol.game.drawables.RectSprite;
import org.destinationsol.game.drawables.SpriteManager;
import org.destinationsol.game.planet.FarSky;
import org.destinationsol.game.planet.Planet;
import org.destinationsol.game.planet.SkyConfig;

public class Sky
implements SolObject {
    private static final String WHITE_TEX_NAME = "engine:planetStarCommonWhiteTex";
    private static final String PLANET_GRADIENT_TEX_NAME = "engine:planetStarCommonGrad";
    private final Planet planet;
    private final RectSprite filling;
    private final RectSprite gradation;
    private final ArrayList<Drawable> drawables;
    private final ColorSpan skySpan;
    private final Vector2 position;

    public Sky(SolGame game, Planet planet) {
        this.planet = planet;
        this.drawables = new ArrayList();
        this.filling = SpriteManager.createSprite(WHITE_TEX_NAME, 5.0f, 0.0f, 0.0f, new Vector2(), DrawableLevel.ATM, 0.0f, 0.0f, SolColor.col(0.5f, 0.0f), false);
        this.drawables.add(this.filling);
        this.gradation = SpriteManager.createSprite(PLANET_GRADIENT_TEX_NAME, 5.0f, 0.0f, 0.0f, new Vector2(), DrawableLevel.ATM, 0.0f, 0.0f, SolColor.col(0.5f, 0.0f), false);
        this.drawables.add(this.gradation);
        SkyConfig config = planet.getConfig().skyConfig;
        this.skySpan = ColorSpan.rgb(config.dawn, config.day);
        this.position = new Vector2();
        this.updatePos(game);
    }

    private void updatePos(SolGame game) {
        Vector2 camPos = game.getCam().getPosition();
        Vector2 planetPos = this.planet.getPosition();
        if (planetPos.dst(camPos) < this.planet.getGroundHeight() + 21.0f) {
            this.position.set(camPos);
            return;
        }
        this.position.set(planetPos);
    }

    @Override
    public void update(SolGame game) {
        this.updatePos(game);
        Vector2 planetPos = this.planet.getPosition();
        SolCam cam = game.getCam();
        Vector2 camPos = cam.getPosition();
        float distPercentage = 1.0f - (planetPos.dst(camPos) - this.planet.getGroundHeight()) / 21.0f;
        if (distPercentage < 0.0f) {
            return;
        }
        if (1.0f < distPercentage) {
            distPercentage = 1.0f;
        }
        Vector2 sysPos = this.planet.getSystem().getPosition();
        float angleToCam = SolMath.angle(planetPos, camPos);
        float angleToSun = SolMath.angle(planetPos, sysPos);
        float dayPercentage = 1.0f - SolMath.angleDiff(angleToCam, angleToSun) / 180.0f;
        float skyIntensity = SolMath.clamp(1.0f - (1.0f - dayPercentage) / 0.75f);
        float skyColorPercentage = SolMath.clamp((skyIntensity - 0.5f) * 2.0f + 0.5f);
        this.skySpan.set(skyColorPercentage, this.gradation.tint);
        this.skySpan.set(skyColorPercentage, this.filling.tint);
        float gradPercentage = SolMath.clamp(2.0f * skyIntensity);
        float fillPercentage = SolMath.clamp(2.0f * (skyIntensity - 0.5f));
        this.gradation.tint.a = gradPercentage * distPercentage;
        this.filling.tint.a = fillPercentage * SolMath.clamp(1.0f - (1.0f - distPercentage) * 2.0f) * 0.37f;
        float viewDist = cam.getViewDistance();
        float sz = 2.0f * viewDist;
        this.gradation.setTextureSize(sz);
        this.filling.setTextureSize(sz);
        float angleCamToSun = angleToCam - angleToSun;
        float relAngle = SolMath.abs(SolMath.norm(angleCamToSun)) < 90.0f ? angleToCam + 180.0f + angleCamToSun : angleToCam - angleCamToSun;
        this.gradation.relativeAngle = relAngle - 90.0f;
    }

    @Override
    public boolean shouldBeRemoved(SolGame game) {
        return false;
    }

    @Override
    public void onRemove(SolGame game) {
    }

    @Override
    public void receiveDmg(float dmg, SolGame game, Vector2 position, DmgType dmgType) {
    }

    @Override
    public boolean receivesGravity() {
        return false;
    }

    @Override
    public void receiveForce(Vector2 force, SolGame game, boolean acc) {
    }

    @Override
    public Vector2 getPosition() {
        return this.position;
    }

    @Override
    public FarObject toFarObject() {
        return new FarSky(this.planet);
    }

    @Override
    public List<Drawable> getDrawables() {
        return this.drawables;
    }

    @Override
    public float getAngle() {
        return 0.0f;
    }

    @Override
    public Vector2 getVelocity() {
        return null;
    }

    @Override
    public void handleContact(SolObject other, float absImpulse, SolGame game, Vector2 collPos) {
    }

    @Override
    public String toDebugString() {
        return null;
    }

    @Override
    public Boolean isMetal() {
        return null;
    }

    @Override
    public boolean hasBody() {
        return false;
    }
}

