/*
 * Decompiled with CFR 0.152.
 */
package org.destinationsol.game.planet;

import com.badlogic.gdx.math.Vector2;
import java.util.ArrayList;
import org.destinationsol.game.HardnessCalc;
import org.destinationsol.game.planet.Planet;
import org.destinationsol.game.planet.SysConfig;
import org.destinationsol.game.planet.SystemBelt;

public class SolSystem {
    private final Vector2 position;
    private final ArrayList<Planet> planets;
    private final ArrayList<SystemBelt> belts;
    private final SysConfig config;
    private final String name;
    private final float radius;
    private final float damagePerSecond;
    private final float innerDamagePerSecond;
    private float innerRadius;

    public SolSystem(Vector2 position, SysConfig config, String name, float sysRadius) {
        this.config = config;
        this.name = name;
        this.position = new Vector2(position);
        this.planets = new ArrayList();
        this.belts = new ArrayList();
        this.radius = sysRadius;
        this.damagePerSecond = HardnessCalc.getSysDps(config, false);
        this.innerRadius = this.radius / 2.0f;
        this.innerDamagePerSecond = HardnessCalc.getSysDps(config, true);
    }

    public ArrayList<Planet> getPlanets() {
        return this.planets;
    }

    public ArrayList<SystemBelt> getBelts() {
        return this.belts;
    }

    public Vector2 getPosition() {
        return this.position;
    }

    public float getRadius() {
        return this.radius;
    }

    public SysConfig getConfig() {
        return this.config;
    }

    public String getName() {
        return this.name;
    }

    public void addBelt(SystemBelt belt) {
        float newInnerRad = belt.getRadius() - belt.getHalfWidth().floatValue();
        if (this.belts.size() == 0 || this.innerRadius < newInnerRad) {
            this.innerRadius = newInnerRad;
        }
        this.belts.add(belt);
    }

    public float getInnerRadius() {
        return this.innerRadius;
    }

    public float getDps() {
        return this.damagePerSecond;
    }

    public float getInnerDps() {
        return this.innerDamagePerSecond;
    }
}

