/*
 * Decompiled with CFR 0.152.
 */
package org.destinationsol.game.planet;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.TextureAtlas;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.math.Vector2;
import org.destinationsol.assets.Assets;
import org.destinationsol.common.SolColor;
import org.destinationsol.common.SolMath;
import org.destinationsol.game.DmgType;
import org.destinationsol.game.GameDrawer;
import org.destinationsol.game.SolGame;
import org.destinationsol.game.SolObject;
import org.destinationsol.game.planet.SolSystem;

public class SunSingleton {
    public static final float SUN_HOT_RAD = 58.5f;
    public static final float GRAV_CONST = 2000.0f;
    private static final float SUN_DMG = 4.0f;
    private final TextureAtlas.AtlasRegion gradatingTexture = Assets.getAtlasRegion("engine:planetStarCommonGrad");
    private final TextureAtlas.AtlasRegion whiteTexture = Assets.getAtlasRegion("engine:planetStarCommonWhiteTex");
    private final Color gradatingTint = SolColor.col(1.0f, 1.0f);
    private final Color fillTint = SolColor.col(1.0f, 1.0f);

    SunSingleton() {
    }

    public void draw(SolGame game, GameDrawer drawer) {
        Vector2 camPos = game.getCam().getPosition();
        SolSystem sys = game.getPlanetManager().getNearestSystem(camPos);
        Vector2 toCam = SolMath.getVec(camPos);
        toCam.sub(sys.getPosition());
        float toCamLen = toCam.len();
        if (toCamLen < 78.0f) {
            float closeness = 1.0f - toCamLen / 78.0f;
            this.gradatingTint.a = MathUtils.clamp((float)(closeness * 4.0f), (float)0.0f, (float)1.0f);
            this.fillTint.a = MathUtils.clamp((float)((closeness - 0.25f) * 4.0f), (float)0.0f, (float)1.0f);
            float sz = 2.0f * game.getCam().getViewDistance();
            float gradAngle = SolMath.angle(toCam) + 90.0f;
            drawer.draw((TextureRegion)this.whiteTexture, sz * 2.0f, sz * 2.0f, sz, sz, camPos.x, camPos.y, 0.0f, this.fillTint);
            drawer.draw((TextureRegion)this.gradatingTexture, sz * 2.0f, sz * 2.0f, sz, sz, camPos.x, camPos.y, gradAngle, this.gradatingTint);
        }
        SolMath.free(toCam);
    }

    public void doDmg(SolGame game, SolObject obj, float toSys) {
        float dmg = 4.0f * game.getTimeStep();
        if (58.5f < toSys) {
            return;
        }
        obj.receiveDmg(dmg, game, null, DmgType.FIRE);
    }
}

