/*
 * Decompiled with CFR 0.152.
 */
package org.destinationsol.game.planet;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.destinationsol.assets.Assets;
import org.destinationsol.assets.json.Json;
import org.destinationsol.assets.json.Validator;
import org.destinationsol.common.SolRandom;
import org.destinationsol.files.HullConfigManager;
import org.destinationsol.game.ShipConfig;
import org.destinationsol.game.chunk.SpaceEnvConfig;
import org.destinationsol.game.item.ItemManager;
import org.destinationsol.game.item.TradeConfig;
import org.destinationsol.game.planet.SysConfig;
import org.json.JSONObject;
import org.terasology.gestalt.assets.ResourceUrn;
import org.terasology.gestalt.naming.Name;

public class SysConfigs {
    private final Map<String, SysConfig> configs = new HashMap<String, SysConfig>();
    private final Map<String, SysConfig> hardConfigs = new HashMap<String, SysConfig>();
    private final Map<String, SysConfig> beltConfigs = new HashMap<String, SysConfig>();
    private final Map<String, SysConfig> hardBeltConfigs = new HashMap<String, SysConfig>();

    public SysConfigs(HullConfigManager hullConfigs, ItemManager itemManager) {
        this.load("systemsConfig", hullConfigs, false, itemManager);
        this.load("asteroidBeltsConfig", hullConfigs, true, itemManager);
    }

    private void load(String configName, HullConfigManager hullConfigs, boolean belts, ItemManager itemManager) {
        JSONObject rootNode = Validator.getValidatedJSON("engine:" + configName, "engine:schemaSystemsConfig");
        for (String s : rootNode.keySet()) {
            if (!(rootNode.get(s) instanceof JSONObject)) continue;
            JSONObject node = rootNode.getJSONObject(s);
            String name = s;
            boolean hard = node.optBoolean("hard", false);
            Map<String, SysConfig> configs = belts ? (hard ? this.hardBeltConfigs : this.beltConfigs) : (hard ? this.hardConfigs : this.configs);
            SpaceEnvConfig envConfig = new SpaceEnvConfig(node.getJSONObject("environment"));
            SysConfig config = new SysConfig(name, new ArrayList<ShipConfig>(), envConfig, new ArrayList<ShipConfig>(), new ArrayList<ShipConfig>(), new TradeConfig(), new ArrayList<ShipConfig>(), hard);
            configs.put(name, config);
        }
        Set<ResourceUrn> configUrnList = Assets.getAssetHelper().listAssets(Json.class, configName, new Name("engine"));
        for (ResourceUrn configUrn : configUrnList) {
            rootNode = Validator.getValidatedJSON(configUrn.toString(), "engine:schemaSystemsConfig");
            for (String s : rootNode.keySet()) {
                if (!(rootNode.get(s) instanceof JSONObject)) continue;
                JSONObject node = rootNode.getJSONObject(s);
                String name = s;
                boolean hard = node.optBoolean("hard", false);
                Map<String, SysConfig> configs = belts ? (hard ? this.hardBeltConfigs : this.beltConfigs) : (hard ? this.hardConfigs : this.configs);
                SysConfig config = configs.get(name);
                config.tempEnemies.addAll(ShipConfig.loadList(node.has("temporaryEnemies") ? node.getJSONArray("temporaryEnemies") : null, hullConfigs, itemManager));
                config.innerTempEnemies.addAll(ShipConfig.loadList(node.has("innerTemporaryEnemies") ? node.getJSONArray("innerTemporaryEnemies") : null, hullConfigs, itemManager));
                if (!belts) {
                    config.constEnemies.addAll(ShipConfig.loadList(node.has("constantEnemies") ? node.getJSONArray("constantEnemies") : null, hullConfigs, itemManager));
                    config.constAllies.addAll(ShipConfig.loadList(node.has("constantAllies") ? node.getJSONArray("constantAllies") : null, hullConfigs, itemManager));
                }
                config.tradeConfig.load(node.has("trading") ? node.getJSONObject("trading") : null, hullConfigs, itemManager);
            }
        }
    }

    public SysConfig getRandomBelt(boolean hard) {
        Map<String, SysConfig> config = hard ? this.hardBeltConfigs : this.beltConfigs;
        return SolRandom.seededRandomElement(new ArrayList<SysConfig>(config.values()));
    }

    public SysConfig getConfig(String name) {
        SysConfig res = this.configs.get(name);
        if (res != null) {
            return res;
        }
        return this.hardConfigs.get(name);
    }

    public SysConfig getRandomCfg(boolean hard) {
        Map<String, SysConfig> config = hard ? this.hardConfigs : this.configs;
        return SolRandom.seededRandomElement(new ArrayList<SysConfig>(config.values()));
    }

    public void addAllConfigs(ArrayList<ShipConfig> shipConfigs) {
        for (SysConfig sc : this.configs.values()) {
            shipConfigs.addAll(sc.constAllies);
            shipConfigs.addAll(sc.constEnemies);
            shipConfigs.addAll(sc.tempEnemies);
            shipConfigs.addAll(sc.innerTempEnemies);
        }
        for (SysConfig sc : this.hardConfigs.values()) {
            shipConfigs.addAll(sc.constAllies);
            shipConfigs.addAll(sc.constEnemies);
            shipConfigs.addAll(sc.tempEnemies);
            shipConfigs.addAll(sc.innerTempEnemies);
        }
        for (SysConfig sc : this.beltConfigs.values()) {
            shipConfigs.addAll(sc.tempEnemies);
        }
        for (SysConfig sc : this.hardBeltConfigs.values()) {
            shipConfigs.addAll(sc.tempEnemies);
        }
    }
}

