/*
 * Decompiled with CFR 0.152.
 */
package org.destinationsol.game.planet;

import com.badlogic.gdx.math.Vector2;
import org.destinationsol.game.HardnessCalc;
import org.destinationsol.game.planet.SolSystem;
import org.destinationsol.game.planet.SysConfig;

public class SystemBelt {
    private final Float halfWidth;
    private final float radius;
    private final SolSystem system;
    private final SysConfig config;
    private final float damagePerSecond;

    SystemBelt(Float halfWidth, float radius, SolSystem s, SysConfig config) {
        this.halfWidth = halfWidth;
        this.radius = radius;
        this.system = s;
        this.config = config;
        this.damagePerSecond = HardnessCalc.getBeltDps(config);
    }

    public float getRadius() {
        return this.radius;
    }

    public Float getHalfWidth() {
        return this.halfWidth;
    }

    public boolean contains(Vector2 position) {
        float toCenter = this.system.getPosition().dst(position);
        return this.radius - this.halfWidth.floatValue() < toCenter && toCenter < this.radius + this.halfWidth.floatValue();
    }

    public SysConfig getConfig() {
        return this.config;
    }

    public float getDps() {
        return this.damagePerSecond;
    }
}

