/*
 * Decompiled with CFR 0.152.
 */
package org.destinationsol.game.planet;

import com.badlogic.gdx.math.Vector2;
import java.util.ArrayList;
import java.util.List;
import org.destinationsol.common.SolMath;
import org.destinationsol.common.SolRandom;
import org.destinationsol.game.DebugOptions;
import org.destinationsol.game.SolNames;
import org.destinationsol.game.maze.Maze;
import org.destinationsol.game.maze.MazeConfig;
import org.destinationsol.game.maze.MazeConfigs;
import org.destinationsol.game.planet.Planet;
import org.destinationsol.game.planet.PlanetConfig;
import org.destinationsol.game.planet.PlanetConfigs;
import org.destinationsol.game.planet.SolSystem;
import org.destinationsol.game.planet.SysConfig;
import org.destinationsol.game.planet.SysConfigs;
import org.destinationsol.game.planet.SystemBelt;

public class SystemsBuilder {
    public static final int DEFAULT_SYSTEM_COUNT = 2;
    public static final int PLANET_COUNT = 5;
    public static final float PLANET_SPD = 0.2f;
    private static final float GROUND_SPD = 0.2f;
    private static final float MAX_MAZE_RADIUS = 40.0f;
    private static final float MAZE_GAP = 10.0f;
    private static final float BELT_HALF_WIDTH = 20.0f;

    public List<SolSystem> build(List<SolSystem> systems, List<Planet> planets, ArrayList<SystemBelt> belts, PlanetConfigs planetConfigs, MazeConfigs mazeConfigs, ArrayList<Maze> mazes, SysConfigs sysConfigs, SolNames names, int systemCount) {
        int sysLeft = systemCount;
        int mazesLeft = systemCount * 2;
        while (sysLeft > 0 || mazesLeft > 0) {
            Vector2 position;
            boolean createSys;
            boolean bl = createSys = sysLeft > 0;
            if (createSys && mazesLeft > 0 && !systems.isEmpty()) {
                createSys = SolRandom.seededTest(0.5f);
            }
            if (createSys) {
                List<Float> ghs = this.generatePlanetGhs();
                float sysRadius = this.calcSysRadius(ghs);
                position = this.getBodyPos(systems, mazes, sysRadius);
                SolSystem s = this.createSystem(ghs, position, planets, belts, planetConfigs, sysRadius, sysConfigs, names, systems.isEmpty());
                systems.add(s);
                --sysLeft;
                continue;
            }
            MazeConfig mc = SolRandom.seededRandomElement(mazeConfigs.configs);
            float mazeRadius = SolRandom.seededRandomFloat(0.7f, 1.0f) * 40.0f;
            position = this.getBodyPos(systems, mazes, mazeRadius + 10.0f);
            Maze m = new Maze(mc, position, mazeRadius);
            mazes.add(m);
            --mazesLeft;
        }
        return systems;
    }

    private List<Float> generatePlanetGhs() {
        ArrayList<Float> res = new ArrayList<Float>();
        boolean beltCreated = false;
        for (int i = 0; i < 5; ++i) {
            float groundHeight;
            boolean createBelt;
            boolean bl = createBelt = !beltCreated && 0 < i && (float)i < 2.5f && SolRandom.seededTest(0.6f);
            if (!createBelt) {
                groundHeight = SolRandom.seededRandomFloat(0.5f, 1.0f) * 25.0f;
            } else {
                groundHeight = -20.0f;
                beltCreated = true;
            }
            res.add(Float.valueOf(groundHeight));
        }
        return res;
    }

    private float calcSysRadius(List<Float> ghs) {
        float r = 0.0f;
        r += 78.0f;
        for (Float groundHeight : ghs) {
            r += 8.0f;
            if (groundHeight.floatValue() > 0.0f) {
                r += 14.0f;
                r += groundHeight.floatValue();
                r += groundHeight.floatValue();
                r += 14.0f;
            } else {
                r -= groundHeight.floatValue();
                r -= groundHeight.floatValue();
            }
            r += 8.0f;
        }
        return r;
    }

    private Vector2 getBodyPos(List<SolSystem> systems, ArrayList<Maze> mazes, float bodyRadius) {
        Vector2 res = new Vector2();
        float dist = 0.0f;
        while (true) {
            for (int i = 0; i < 20; ++i) {
                float angle = SolRandom.seededRandomFloat(180.0f);
                SolMath.fromAl(res, angle, dist);
                boolean good = true;
                for (SolSystem system : systems) {
                    if (!(system.getPosition().dst(res) < system.getRadius() + bodyRadius)) continue;
                    good = false;
                    break;
                }
                for (Maze maze : mazes) {
                    if (!(maze.getPos().dst(res) < maze.getRadius() + bodyRadius)) continue;
                    good = false;
                    break;
                }
                if (!good) continue;
                return res;
            }
            dist += 78.0f;
        }
    }

    private SolSystem createSystem(List<Float> groundHeights, Vector2 systemPosition, List<Planet> planets, ArrayList<SystemBelt> belts, PlanetConfigs planetConfigs, float systemRadius, SysConfigs sysConfigs, SolNames names, boolean firstSys) {
        boolean hard = !firstSys;
        String systemType = DebugOptions.FORCE_SYSTEM_TYPE;
        SysConfig sysConfig = systemType.isEmpty() ? sysConfigs.getRandomCfg(hard) : sysConfigs.getConfig(systemType);
        String name = firstSys ? SolRandom.seededRandomElement(names.systems) : "Sol";
        SolSystem system = new SolSystem(systemPosition, sysConfig, name, systemRadius);
        float planetDist = 78.0f;
        for (Float groundHeight : groundHeights) {
            float reserved = groundHeight.floatValue() > 0.0f ? 22.0f + groundHeight.floatValue() : 8.0f - groundHeight.floatValue();
            planetDist += reserved;
            if (groundHeight.floatValue() > 0.0f) {
                PlanetConfig planetConfig;
                String pt = DebugOptions.FORCE_PLANET_TYPE;
                if (pt.isEmpty()) {
                    boolean inner = planetDist < systemRadius / 2.0f;
                    planetConfig = planetConfigs.getRandom(!inner && !hard, inner && hard);
                } else {
                    planetConfig = planetConfigs.getConfig(pt);
                }
                Planet planet = this.createPlanet(planetDist, system, groundHeight.floatValue(), planetConfig, names);
                planets.add(planet);
                system.getPlanets().add(planet);
            } else {
                SysConfig beltConfig = sysConfigs.getRandomBelt(hard);
                SystemBelt belt = new SystemBelt(Float.valueOf(-groundHeight.floatValue()), planetDist, system, beltConfig);
                belts.add(belt);
                system.addBelt(belt);
            }
            planetDist += reserved;
        }
        if (SolMath.abs(systemRadius - planetDist) > 0.1f) {
            throw new AssertionError((Object)(systemRadius + " " + planetDist));
        }
        return system;
    }

    private Planet createPlanet(float planetDist, SolSystem s, float groundHeight, PlanetConfig planetConfig, SolNames names) {
        float toSysRotationSpeed = SolMath.arcToAngle(0.2f, planetDist) * (float)SolMath.toInt(SolRandom.seededTest(0.5f));
        float rotationSpeed = SolMath.arcToAngle(0.2f, groundHeight) * (float)SolMath.toInt(SolRandom.seededTest(0.5f));
        String name = (String)SolRandom.seededRandomElement((List)names.planets.get(planetConfig.moduleName));
        return new Planet(s, SolRandom.seededRandomFloat(180.0f), planetDist, SolRandom.seededRandomFloat(180.0f), toSysRotationSpeed, rotationSpeed, groundHeight, false, planetConfig, name);
    }
}

