/*
 * Decompiled with CFR 0.152.
 */
package org.destinationsol.game.planet;

import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.physics.box2d.Body;
import com.badlogic.gdx.physics.box2d.BodyDef;
import com.badlogic.gdx.physics.box2d.ChainShape;
import com.badlogic.gdx.physics.box2d.Fixture;
import com.badlogic.gdx.physics.box2d.Shape;
import java.util.ArrayList;
import org.destinationsol.common.SolColor;
import org.destinationsol.common.SolMath;
import org.destinationsol.game.SolGame;
import org.destinationsol.game.drawables.DrawableLevel;
import org.destinationsol.game.drawables.animated.AnimatedRectSprite;
import org.destinationsol.game.planet.Planet;
import org.destinationsol.game.planet.Tile;
import org.destinationsol.game.planet.TileObject;

public class TileObjBuilder {
    public TileObject build(SolGame game, float size, float toPlanetRelAngle, float distance, Tile tile, Planet planet) {
        float spriteSize = size * 2.0f;
        AnimatedRectSprite sprite = new AnimatedRectSprite(tile.sprite.frames, spriteSize, 0.0f, 0.0f, new Vector2(), DrawableLevel.GROUND, 0.0f, 0.0f, SolColor.WHITE, false);
        Body body = null;
        if (tile.points.size() > 0) {
            body = this.buildBody(game, toPlanetRelAngle, distance, tile, planet, spriteSize);
        }
        TileObject res = new TileObject(planet, toPlanetRelAngle, distance, size, sprite, body, tile);
        if (body != null) {
            body.setUserData((Object)res);
        }
        return res;
    }

    private Body buildBody(SolGame game, float toPlanetRelAngle, float dist, Tile tile, Planet planet, float spriteSize) {
        BodyDef bodyDef = new BodyDef();
        bodyDef.type = BodyDef.BodyType.KinematicBody;
        float toPlanetAngle = planet.getAngle() + toPlanetRelAngle;
        SolMath.fromAl(bodyDef.position, toPlanetAngle, dist);
        bodyDef.position.add(planet.getPosition());
        bodyDef.angle = (toPlanetAngle + 90.0f) * ((float)Math.PI / 180);
        bodyDef.angularDamping = 0.0f;
        Body body = game.getObjectManager().getWorld().createBody(bodyDef);
        ChainShape shape = new ChainShape();
        ArrayList<Vector2> points = new ArrayList<Vector2>();
        for (Vector2 curr : tile.points) {
            points.add(new Vector2(curr).scl(spriteSize));
        }
        shape.createLoop(points.toArray(new Vector2[0]));
        Fixture fixture = body.createFixture((Shape)shape, 0.0f);
        fixture.setFriction(0.5f);
        shape.dispose();
        return body;
    }
}

