/*
 * Decompiled with CFR 0.152.
 */
package org.destinationsol.game.planet;

import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.physics.box2d.Body;
import java.util.ArrayList;
import java.util.List;
import org.destinationsol.common.SolMath;
import org.destinationsol.game.DmgType;
import org.destinationsol.game.FarObject;
import org.destinationsol.game.SolGame;
import org.destinationsol.game.SolObject;
import org.destinationsol.game.drawables.Drawable;
import org.destinationsol.game.drawables.RectSprite;
import org.destinationsol.game.planet.FarTileObject;
import org.destinationsol.game.planet.Planet;
import org.destinationsol.game.planet.Tile;

public class TileObject
implements SolObject {
    private final Planet planet;
    private final float relativeAngleToPlanet;
    private final float distance;
    private final List<Drawable> drawables;
    private final Body body;
    private final Vector2 position;
    private final float size;
    private final Tile tile;
    private float angle;

    TileObject(Planet planet, float relativeAngleToPlanet, float distance, float size, RectSprite sprite, Body body, Tile tile) {
        this.tile = tile;
        this.drawables = new ArrayList<Drawable>();
        this.planet = planet;
        this.relativeAngleToPlanet = relativeAngleToPlanet;
        this.distance = distance;
        this.size = size;
        this.body = body;
        this.position = new Vector2();
        this.drawables.add(sprite);
        this.setDependentParams();
    }

    @Override
    public void update(SolGame game) {
        this.setDependentParams();
        if (this.body != null) {
            float timeStep = game.getTimeStep();
            Vector2 velocity = SolMath.getVec(this.position);
            velocity.sub(this.body.getPosition());
            velocity.scl(1.0f / timeStep);
            this.body.setLinearVelocity(velocity);
            SolMath.free(velocity);
            float bodyAngle = this.body.getAngle() * 57.295776f;
            float angularVelocity = SolMath.norm(this.angle - bodyAngle) * ((float)Math.PI / 180) / timeStep;
            this.body.setAngularVelocity(angularVelocity);
        }
    }

    private void setDependentParams() {
        float toPlanetAngle = this.planet.getAngle() + this.relativeAngleToPlanet;
        SolMath.fromAl(this.position, toPlanetAngle, this.distance);
        this.position.add(this.planet.getPosition());
        this.angle = toPlanetAngle + 90.0f;
    }

    @Override
    public boolean shouldBeRemoved(SolGame game) {
        return false;
    }

    @Override
    public void onRemove(SolGame game) {
        if (this.body != null) {
            this.body.getWorld().destroyBody(this.body);
        }
    }

    @Override
    public void receiveDmg(float dmg, SolGame game, Vector2 position, DmgType dmgType) {
        game.getSpecialSounds().playHit(game, this, position, dmgType);
    }

    @Override
    public boolean receivesGravity() {
        return false;
    }

    @Override
    public void receiveForce(Vector2 force, SolGame game, boolean acc) {
    }

    @Override
    public Vector2 getPosition() {
        return this.position;
    }

    @Override
    public FarObject toFarObject() {
        return new FarTileObject(this.planet, this.relativeAngleToPlanet, this.distance, this.size, this.tile);
    }

    @Override
    public List<Drawable> getDrawables() {
        return this.drawables;
    }

    @Override
    public float getAngle() {
        return this.angle;
    }

    @Override
    public Vector2 getVelocity() {
        return null;
    }

    @Override
    public void handleContact(SolObject other, float absImpulse, SolGame game, Vector2 collPos) {
    }

    @Override
    public String toDebugString() {
        return null;
    }

    @Override
    public Boolean isMetal() {
        return false;
    }

    @Override
    public boolean hasBody() {
        return true;
    }

    public Planet getPlanet() {
        return this.planet;
    }

    public float getSz() {
        return this.size;
    }

    public Tile getTile() {
        return this.tile;
    }
}

