/*
 * Decompiled with CFR 0.152.
 */
package org.destinationsol.game.projectile;

import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.physics.box2d.Body;
import org.destinationsol.common.SolMath;
import org.destinationsol.game.SolGame;
import org.destinationsol.game.asteroid.AsteroidBuilder;
import org.destinationsol.game.projectile.Projectile;
import org.destinationsol.game.projectile.ProjectileBody;
import org.destinationsol.game.projectile.ProjectileConfig;
import org.destinationsol.game.ship.SolShip;

public class BallProjectileBody
implements ProjectileBody {
    private final Body body;
    private final Vector2 position;
    private final Vector2 velocity;
    private final float acceleration;
    private final float mass;
    private float angle;

    BallProjectileBody(SolGame game, Vector2 position, float angle, Projectile projectile, Vector2 gunVelocity, float speed, ProjectileConfig config) {
        float density = config.density == -1.0f ? 1.0f : config.density;
        this.body = AsteroidBuilder.buildBall(game, position, angle, config.physSize / 2.0f, density, config.massless);
        if (config.zeroAbsSpeed) {
            this.body.setAngularVelocity(0.2617994f);
        }
        this.velocity = new Vector2();
        SolMath.fromAl(this.velocity, angle, speed);
        this.velocity.add(gunVelocity);
        this.body.setLinearVelocity(this.velocity);
        this.body.setUserData((Object)projectile);
        this.position = new Vector2();
        this.acceleration = config.acc;
        this.mass = this.body.getMass();
        this.setParamsFromBody();
    }

    private void setParamsFromBody() {
        this.position.set(this.body.getPosition());
        this.angle = this.body.getAngle() * 57.295776f;
        this.velocity.set(this.body.getLinearVelocity());
    }

    @Override
    public void update(SolGame game) {
        this.setParamsFromBody();
        if (this.acceleration > 0.0f && SolMath.canAccelerate(this.angle, this.velocity)) {
            Vector2 force = SolMath.fromAl(this.angle, this.acceleration * this.mass);
            this.body.applyForceToCenter(force, true);
            SolMath.free(force);
        }
    }

    @Override
    public Vector2 getPosition() {
        return this.position;
    }

    @Override
    public Vector2 getVelocity() {
        return this.velocity;
    }

    @Override
    public void receiveForce(Vector2 force, SolGame game, boolean acc) {
        if (acc) {
            force.scl(this.mass);
        }
        this.body.applyForceToCenter(force, true);
    }

    @Override
    public void onRemove(SolGame game) {
        this.body.getWorld().destroyBody(this.body);
    }

    @Override
    public float getAngle() {
        return this.angle;
    }

    @Override
    public void changeAngle(float diff) {
        this.angle += diff;
        this.body.setTransform(this.position, this.angle * ((float)Math.PI / 180));
        this.body.setAngularVelocity(0.0f);
    }

    @Override
    public float getDesiredAngle(SolShip nearestEnemy) {
        float speed = this.velocity.len();
        if (speed < 3.0f) {
            speed = 3.0f;
        }
        float distanceToNearestEnemy = SolMath.angle(this.position, nearestEnemy.getPosition());
        Vector2 desiredVelocity = SolMath.fromAl(distanceToNearestEnemy, speed);
        desiredVelocity.add(nearestEnemy.getVelocity());
        float result = SolMath.angle(this.velocity, desiredVelocity);
        SolMath.free(desiredVelocity);
        return result;
    }
}

