/*
 * Decompiled with CFR 0.152.
 */
package org.destinationsol.game.projectile;

import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.physics.box2d.Fixture;
import com.badlogic.gdx.physics.box2d.RayCastCallback;
import org.destinationsol.common.SolMath;
import org.destinationsol.game.SolGame;
import org.destinationsol.game.SolObject;
import org.destinationsol.game.projectile.Projectile;
import org.destinationsol.game.projectile.ProjectileBody;
import org.destinationsol.game.ship.SolShip;

public class PointProjectileBody
implements ProjectileBody {
    private final Vector2 position;
    private final Vector2 velocity;
    private final ProjectileRayBack rayBack;
    private final float acceleration;

    public PointProjectileBody(float angle, Vector2 muzzlePos, Vector2 gunVelocity, float speed, Projectile projectile, SolGame game, float acceleration) {
        this.position = new Vector2(muzzlePos);
        this.velocity = new Vector2();
        SolMath.fromAl(this.velocity, angle, speed);
        this.velocity.add(gunVelocity);
        this.rayBack = new ProjectileRayBack(projectile, game);
        this.acceleration = acceleration;
    }

    @Override
    public void update(SolGame game) {
        float speed;
        if (this.acceleration > 0.0f && SolMath.canAccelerate(this.acceleration, this.velocity) && (speed = this.velocity.len()) < 8.0f) {
            this.velocity.scl((speed + this.acceleration) / speed);
        }
        Vector2 prevPos = SolMath.getVec(this.position);
        Vector2 diff = SolMath.getVec(this.velocity);
        diff.scl(game.getTimeStep());
        this.position.add(diff);
        SolMath.free(diff);
        game.getObjectManager().getWorld().rayCast((RayCastCallback)this.rayBack, prevPos, this.position);
        SolMath.free(prevPos);
    }

    @Override
    public Vector2 getPosition() {
        return this.position;
    }

    @Override
    public void receiveForce(Vector2 force, SolGame game, boolean acc) {
        force.scl(game.getTimeStep());
        if (!acc) {
            force.scl(10.0f);
        }
        this.velocity.add(force);
    }

    @Override
    public Vector2 getVelocity() {
        return this.velocity;
    }

    @Override
    public void onRemove(SolGame game) {
    }

    @Override
    public float getAngle() {
        return SolMath.angle(this.velocity);
    }

    @Override
    public void changeAngle(float diff) {
        SolMath.rotate(this.velocity, diff);
    }

    @Override
    public float getDesiredAngle(SolShip ne) {
        return SolMath.angle(this.position, ne.getPosition());
    }

    private class ProjectileRayBack
    implements RayCastCallback {
        private final Projectile projectile;
        private final SolGame game;

        private ProjectileRayBack(Projectile projectile, SolGame game) {
            this.projectile = projectile;
            this.game = game;
        }

        public float reportRayFixture(Fixture fixture, Vector2 point, Vector2 normal, float fraction) {
            boolean oIsMassless;
            SolObject o = (SolObject)fixture.getBody().getUserData();
            boolean bl = oIsMassless = o instanceof Projectile && ((Projectile)o).isMassless();
            if (!oIsMassless && this.projectile.shouldCollide(o, fixture, this.game.getFactionMan())) {
                PointProjectileBody.this.position.set(point);
                this.projectile.setObstacle(o, this.game);
                return 0.0f;
            }
            return -1.0f;
        }
    }
}

