/*
 * Decompiled with CFR 0.152.
 */
package org.destinationsol.game.projectile;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.Animation;
import com.badlogic.gdx.graphics.g2d.TextureAtlas;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.physics.box2d.Fixture;
import java.util.ArrayList;
import java.util.List;
import org.destinationsol.common.SolColor;
import org.destinationsol.common.SolMath;
import org.destinationsol.common.SolRandom;
import org.destinationsol.game.DmgType;
import org.destinationsol.game.Faction;
import org.destinationsol.game.FactionManager;
import org.destinationsol.game.FarObject;
import org.destinationsol.game.GameDrawer;
import org.destinationsol.game.SolGame;
import org.destinationsol.game.SolObject;
import org.destinationsol.game.drawables.Drawable;
import org.destinationsol.game.drawables.DrawableLevel;
import org.destinationsol.game.drawables.SpriteManager;
import org.destinationsol.game.item.Shield;
import org.destinationsol.game.particle.DSParticleEmitter;
import org.destinationsol.game.particle.EffectConfig;
import org.destinationsol.game.particle.LightSource;
import org.destinationsol.game.projectile.BallProjectileBody;
import org.destinationsol.game.projectile.PointProjectileBody;
import org.destinationsol.game.projectile.ProjectileBody;
import org.destinationsol.game.projectile.ProjectileConfig;
import org.destinationsol.game.ship.SolShip;

public class Projectile
implements SolObject {
    private static final float MIN_ANGLE_TO_GUIDE = 2.0f;
    private final ArrayList<Drawable> drawables = new ArrayList();
    private final ProjectileBody body;
    private final Faction faction;
    private final DSParticleEmitter bodyEffect;
    private final DSParticleEmitter trailEffect;
    private final LightSource lightSource;
    private final ProjectileConfig config;
    private boolean shouldBeRemoved;
    private SolObject obstacle;
    private SolShip ship;
    private boolean wasDamageDealt;

    public Projectile(SolGame game, float angle, Vector2 muzzlePos, Vector2 gunVelocity, Faction faction, ProjectileConfig config, boolean varySpeed, SolShip ship) {
        this.config = config;
        this.ship = ship;
        Drawable drawable = config.stretch ? new ProjectileDrawable(this, config.sprite.frames, config.texSz) : SpriteManager.createSprite(config.sprite.displayName, config.texSz, config.origin.x, config.origin.y, new Vector2(), DrawableLevel.PROJECTILES, 0.0f, 0.0f, SolColor.WHITE, false);
        this.drawables.add(drawable);
        float speed = config.speed;
        if (varySpeed) {
            speed *= SolRandom.randomFloat(0.9f, 1.1f);
        }
        this.body = config.physSize > 0.0f ? new BallProjectileBody(game, muzzlePos, angle, this, gunVelocity, speed, config) : new PointProjectileBody(angle, muzzlePos, gunVelocity, speed, this, game, config.acc);
        this.faction = faction;
        this.bodyEffect = this.buildEffect(game, config.bodyEffect, DrawableLevel.PART_BG_0, null, true);
        this.trailEffect = this.buildEffect(game, config.trailEffect, DrawableLevel.PART_BG_0, null, false);
        if (config.lightSz > 0.0f) {
            Color col = SolColor.WHITE;
            if (this.bodyEffect != null) {
                col = config.bodyEffect.tint;
            }
            this.lightSource = new LightSource(config.lightSz, true, 1.0f, new Vector2(), col);
            this.lightSource.collectDrawables(this.drawables);
        } else {
            this.lightSource = null;
        }
    }

    private DSParticleEmitter buildEffect(SolGame game, EffectConfig ec, DrawableLevel drawableLevel, Vector2 position, boolean inheritsVelocity) {
        if (ec == null) {
            return null;
        }
        DSParticleEmitter res = new DSParticleEmitter(ec, -1.0f, drawableLevel, new Vector2(), inheritsVelocity, game, position, this.body.getVelocity(), 0.0f);
        if (res.isContinuous()) {
            res.setWorking(true);
            this.drawables.addAll(res.getDrawables());
        } else {
            game.getPartMan().finish(game, res, position);
        }
        return res;
    }

    @Override
    public void update(SolGame game) {
        this.body.update(game);
        if (this.obstacle != null) {
            if (!this.wasDamageDealt) {
                if (this.config.aoeRadius >= 0.0f) {
                    game.getObjectManager().doToAllCloserThan(this.config.aoeRadius, this, obj -> obj.receiveDmg(this.config.dmg, game, this.body.getPosition(), this.config.dmgType));
                } else {
                    this.obstacle.receiveDmg(this.config.dmg, game, this.body.getPosition(), this.config.dmgType);
                }
            }
            if (this.config.density > 0.0f) {
                this.obstacle = null;
                this.wasDamageDealt = true;
            } else {
                this.collided(game);
                if (this.config.emTime > 0.0f && this.obstacle instanceof SolShip) {
                    ((SolShip)this.obstacle).disableControls(this.config.emTime, game);
                }
                return;
            }
        }
        if (this.lightSource != null) {
            this.lightSource.update(true, this.body.getAngle(), game);
        }
        this.maybeGuide(game);
        game.getSoundManager().play(game, this.config.workSound, null, this);
    }

    private void maybeGuide(SolGame game) {
        float angle;
        if (this.config.guideRotationSpeed == 0.0f) {
            return;
        }
        float ts = game.getTimeStep();
        SolShip ne = game.getFactionMan().getNearestEnemy(game, this);
        if (ne == null) {
            return;
        }
        float desiredAngle = this.body.getDesiredAngle(ne);
        float diffAngle = SolMath.norm(desiredAngle - (angle = this.getAngle()));
        if (SolMath.abs(diffAngle) < 2.0f) {
            return;
        }
        float rot = ts * this.config.guideRotationSpeed;
        float min = -rot;
        diffAngle = MathUtils.clamp((float)diffAngle, (float)min, (float)rot);
        this.body.changeAngle(diffAngle);
    }

    private void collided(SolGame game) {
        this.shouldBeRemoved = true;
        Vector2 position = this.body.getPosition();
        this.buildEffect(game, this.config.collisionEffect, DrawableLevel.PART_FG_1, position, false);
        this.buildEffect(game, this.config.collisionEffectBackground, DrawableLevel.PART_FG_0, position, false);
        if (this.config.collisionEffectBackground != null) {
            game.getPartMan().blinks(position, game, this.config.collisionEffectBackground.size);
        }
        if (this.ship.getPilot().isPlayer() && this.obstacle instanceof SolShip) {
            this.ship.changeDisposition(((SolShip)this.obstacle).getFactionID());
        }
        game.getSoundManager().play(game, this.config.collisionSound, null, this);
    }

    @Override
    public boolean shouldBeRemoved(SolGame game) {
        return this.shouldBeRemoved;
    }

    @Override
    public void onRemove(SolGame game) {
        Vector2 position = this.body.getPosition();
        if (this.bodyEffect != null) {
            game.getPartMan().finish(game, this.bodyEffect, position);
        }
        if (this.trailEffect != null) {
            game.getPartMan().finish(game, this.trailEffect, position);
        }
        this.body.onRemove(game);
    }

    @Override
    public void receiveDmg(float dmg, SolGame game, Vector2 position, DmgType dmgType) {
        if (this.config.density > 0.0f) {
            return;
        }
        this.collided(game);
    }

    @Override
    public boolean receivesGravity() {
        return !this.config.massless;
    }

    @Override
    public void receiveForce(Vector2 force, SolGame game, boolean acc) {
        this.body.receiveForce(force, game, acc);
    }

    @Override
    public Vector2 getPosition() {
        return this.body.getPosition();
    }

    @Override
    public FarObject toFarObject() {
        return null;
    }

    @Override
    public List<Drawable> getDrawables() {
        return this.drawables;
    }

    @Override
    public float getAngle() {
        return this.body.getAngle();
    }

    @Override
    public Vector2 getVelocity() {
        return this.body.getVelocity();
    }

    @Override
    public void handleContact(SolObject other, float absImpulse, SolGame game, Vector2 collPos) {
    }

    @Override
    public String toDebugString() {
        return null;
    }

    @Override
    public Boolean isMetal() {
        return null;
    }

    @Override
    public boolean hasBody() {
        return true;
    }

    public Faction getFaction() {
        return this.faction;
    }

    public boolean shouldCollide(SolObject object, Fixture fixture, FactionManager factionManager) {
        if (object instanceof SolShip) {
            SolShip ship = (SolShip)object;
            if (this.ship == ship) {
                return false;
            }
            if (ship.getHull().getShieldFixture() == fixture) {
                if (this.config.density > 0.0f) {
                    return false;
                }
                Shield shield = ship.getShield();
                return shield != null && shield.canAbsorb(this.config.dmgType);
            }
            return true;
        }
        return true;
    }

    public void setObstacle(SolObject object, SolGame game) {
        if (!this.shouldCollide(object, null, game.getFactionMan())) {
            return;
        }
        this.obstacle = object;
    }

    public boolean isMassless() {
        return this.config.massless;
    }

    public ProjectileConfig getConfig() {
        return this.config;
    }

    private static class ProjectileDrawable
    implements Drawable {
        private final Projectile projectile;
        private final Animation<TextureAtlas.AtlasRegion> animation;
        private final float width;
        private TextureAtlas.AtlasRegion texture;
        private float animationTime;

        ProjectileDrawable(Projectile projectile, Animation<TextureAtlas.AtlasRegion> animation, float width) {
            this.projectile = projectile;
            this.animation = animation;
            this.texture = (TextureAtlas.AtlasRegion)animation.getKeyFrame(this.animationTime, true);
            this.width = width;
        }

        @Override
        public TextureAtlas.AtlasRegion getTexture() {
            return this.texture;
        }

        @Override
        public DrawableLevel getLevel() {
            return DrawableLevel.PROJECTILES;
        }

        @Override
        public void update(SolGame game, SolObject o) {
            this.animationTime += game.getTimeStep();
            this.texture = (TextureAtlas.AtlasRegion)this.animation.getKeyFrame(this.animationTime, true);
        }

        @Override
        public void prepare(SolObject o) {
        }

        @Override
        public Vector2 getPosition() {
            return this.projectile.getPosition();
        }

        @Override
        public Vector2 getRelativePosition() {
            return Vector2.Zero;
        }

        @Override
        public float getRadius() {
            return ((Projectile)this.projectile).config.texSz / 2.0f;
        }

        @Override
        public void draw(GameDrawer drawer, SolGame game) {
            float h = this.width;
            float minH = game.getCam().getRealLineWidth() * 3.0f;
            if (h < minH) {
                h = minH;
            }
            Vector2 position = this.projectile.getPosition();
            float w = this.projectile.getVelocity().len() * game.getTimeStep();
            if (w < 4.0f * h) {
                w = 4.0f * h;
            }
            drawer.draw((TextureRegion)this.texture, w, h, w, h / 2.0f, position.x, position.y, SolMath.angle(this.projectile.getVelocity()), SolColor.LG);
        }

        @Override
        public boolean isEnabled() {
            return true;
        }

        @Override
        public boolean okToRemove() {
            return false;
        }
    }
}

