/*
 * Decompiled with CFR 0.152.
 */
package org.destinationsol.game.projectile;

import com.badlogic.gdx.math.Vector2;
import org.destinationsol.assets.sound.PlayableSound;
import org.destinationsol.game.DmgType;
import org.destinationsol.game.drawables.SpriteInfo;
import org.destinationsol.game.particle.EffectConfig;

public class ProjectileConfig {
    public final SpriteInfo sprite;
    public final float texSz;
    public final float speed;
    public final float physSize;
    public final boolean stretch;
    public final DmgType dmgType;
    public final PlayableSound collisionSound;
    public final float lightSz;
    public final EffectConfig trailEffect;
    public final EffectConfig bodyEffect;
    public final EffectConfig collisionEffect;
    public final EffectConfig collisionEffectBackground;
    public final boolean zeroAbsSpeed;
    public final Vector2 origin;
    public final float acc;
    public final PlayableSound workSound;
    public final boolean massless;
    public final float density;
    public final float guideRotationSpeed;
    public final float dmg;
    public final float emTime;
    public final float aoeRadius;

    public ProjectileConfig(SpriteInfo sprite, float texSz, float speed, boolean stretch, float physSize, DmgType dmgType, PlayableSound collisionSound, float lightSz, EffectConfig trailEffect, EffectConfig bodyEffect, EffectConfig collisionEffect, EffectConfig collisionEffectBackground, boolean zeroAbsSpeed, Vector2 origin, float acc, PlayableSound workSound, boolean massless, float density, float guideRotationSpeed, float dmg, float emTime, float aoeRadius) {
        this.sprite = sprite;
        this.texSz = texSz;
        this.speed = speed;
        this.stretch = stretch;
        this.physSize = physSize;
        this.dmgType = dmgType;
        this.collisionSound = collisionSound;
        this.lightSz = lightSz;
        this.trailEffect = trailEffect;
        this.bodyEffect = bodyEffect;
        this.collisionEffect = collisionEffect;
        this.collisionEffectBackground = collisionEffectBackground;
        this.zeroAbsSpeed = zeroAbsSpeed;
        this.origin = origin;
        this.acc = acc;
        this.workSound = workSound;
        this.massless = massless;
        this.density = density;
        this.guideRotationSpeed = guideRotationSpeed;
        this.dmg = dmg;
        this.emTime = emTime;
        this.aoeRadius = aoeRadius;
        if (physSize == 0.0f && massless) {
            throw new AssertionError((Object)"only projectiles with physSize > 0 can be massless");
        }
        if (density > 0.0f && (physSize == 0.0f || massless)) {
            throw new AssertionError((Object)"density on a massless projectile");
        }
    }
}

