/*
 * Decompiled with CFR 0.152.
 */
package org.destinationsol.game.projectile;

import com.badlogic.gdx.graphics.g2d.Animation;
import com.badlogic.gdx.graphics.g2d.TextureAtlas;
import com.badlogic.gdx.math.Vector2;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.destinationsol.assets.Assets;
import org.destinationsol.assets.json.Json;
import org.destinationsol.assets.json.Validator;
import org.destinationsol.assets.sound.OggSound;
import org.destinationsol.assets.sound.OggSoundManager;
import org.destinationsol.common.SolMath;
import org.destinationsol.game.DmgType;
import org.destinationsol.game.GameColors;
import org.destinationsol.game.drawables.SpriteInfo;
import org.destinationsol.game.particle.EffectConfig;
import org.destinationsol.game.particle.EffectTypes;
import org.destinationsol.game.projectile.ProjectileConfig;
import org.json.JSONObject;
import org.terasology.gestalt.assets.ResourceUrn;

public class ProjectileConfigs {
    private final Map<String, ProjectileConfig> configs = new HashMap<String, ProjectileConfig>();

    public ProjectileConfigs(OggSoundManager soundManager, EffectTypes effectTypes, GameColors cols) {
        Set<ResourceUrn> projectileConfigurationFiles = Assets.getAssetHelper().listAssets(Json.class, "projectilesConfig");
        for (ResourceUrn configUrn : projectileConfigurationFiles) {
            JSONObject rootNode = Validator.getValidatedJSON(configUrn.toString(), "engine:schemaProjectileConfig");
            for (String s : rootNode.keySet()) {
                if (!(rootNode.get(s) instanceof JSONObject)) continue;
                JSONObject node = rootNode.getJSONObject(s);
                String name = s;
                String texName = node.getString("tex");
                String projectileTexName = texName + "Projectile";
                TextureAtlas.AtlasRegion tex = Assets.getAtlasRegion(projectileTexName);
                Animation<TextureAtlas.AtlasRegion> animation = Assets.getAnimation(projectileTexName);
                SpriteInfo sprite = new SpriteInfo(tex.name, animation);
                float texSz = (float)node.getDouble("texSz");
                float speed = (float)node.getDouble("speed");
                float physSize = (float)node.optDouble("physSize", 0.0);
                boolean stretch = node.optBoolean("stretch", false);
                DmgType dmgType = DmgType.forName(node.getString("dmgType"));
                String collisionSoundUrn = node.optString("collisionSound", "");
                OggSound collisionSound = collisionSoundUrn.isEmpty() ? null : soundManager.getSound(collisionSoundUrn);
                float lightSz = (float)node.optDouble("lightSz", 0.0);
                EffectConfig trailEffect = EffectConfig.load(node.has("trailEffect") ? node.getJSONObject("trailEffect") : null, effectTypes, cols);
                EffectConfig bodyEffect = EffectConfig.load(node.has("bodyEffect") ? node.getJSONObject("bodyEffect") : null, effectTypes, cols);
                EffectConfig collisionEffect = EffectConfig.load(node.has("collisionEffect") ? node.getJSONObject("collisionEffect") : null, effectTypes, cols);
                EffectConfig collisionEffectBackground = EffectConfig.load(node.has("collisionEffectBg") ? node.getJSONObject("collisionEffectBg") : null, effectTypes, cols);
                float guideRotationSpeed = (float)node.optDouble("guideRotationSpeed", 0.0);
                boolean zeroAbsSpeed = node.optBoolean("zeroAbsSpd", false);
                Vector2 origin = SolMath.readV2(node.optString("texOrig", "0 0"));
                float acc = (float)node.optDouble("acceleration", 0.0);
                String workSoundUrn = node.optString("workSound", "");
                OggSound workSound = workSoundUrn.isEmpty() ? null : soundManager.getSound(workSoundUrn);
                boolean bodyless = node.optBoolean("massless", false);
                float density = (float)node.optDouble("density", -1.0);
                float dmg = (float)node.getDouble("dmg");
                float emTime = (float)node.optDouble("emTime", 0.0);
                float aoeRadius = (float)node.optDouble("aoeRadius", -1.0);
                ProjectileConfig config = new ProjectileConfig(sprite, texSz, speed, stretch, physSize, dmgType, collisionSound, lightSz, trailEffect, bodyEffect, collisionEffect, collisionEffectBackground, zeroAbsSpeed, origin, acc, workSound, bodyless, density, guideRotationSpeed, dmg, emTime, aoeRadius);
                this.configs.put(name, config);
            }
        }
    }

    public ProjectileConfig find(String name) {
        return this.configs.get(name);
    }
}

