/*
 * Decompiled with CFR 0.152.
 */
package org.destinationsol.game.screens;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.TextureAtlas;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.math.Vector2;
import java.util.ArrayList;
import java.util.List;
import org.destinationsol.SolApplication;
import org.destinationsol.assets.Assets;
import org.destinationsol.common.SolColor;
import org.destinationsol.common.SolMath;
import org.destinationsol.game.Faction;
import org.destinationsol.game.FactionManager;
import org.destinationsol.game.HardnessCalc;
import org.destinationsol.game.Hero;
import org.destinationsol.game.MapDrawer;
import org.destinationsol.game.SolCam;
import org.destinationsol.game.SolGame;
import org.destinationsol.game.SolObject;
import org.destinationsol.game.StarPort;
import org.destinationsol.game.planet.Planet;
import org.destinationsol.game.planet.PlanetManager;
import org.destinationsol.game.planet.SolSystem;
import org.destinationsol.game.ship.FarShip;
import org.destinationsol.game.ship.SolShip;
import org.destinationsol.ui.DisplayDimensions;
import org.destinationsol.ui.UiDrawer;
import org.destinationsol.ui.Waypoint;

public class BorderDrawer {
    private DisplayDimensions displayDimensions;
    public static final float PLANET_PROXIMITY_INDICATOR_SIZE = 0.02f;
    private static final float BORDER_ICON_SZ = 0.12f;
    private static final float MAX_ICON_DIST = 14.0f;
    private static final float MAX_DRAW_DIST = 78.0f;
    private final ArrayList<PlanetProximityIndicator> planetProximityIndicators;
    private final Vector2 myTmpVec = new Vector2();

    BorderDrawer() {
        PlanetProximityIndicator t2;
        PlanetProximityIndicator t;
        int i;
        this.displayDimensions = SolApplication.displayDimensions;
        TextureAtlas.AtlasRegion texture = Assets.getAtlasRegion("engine:uiPlanetProximityIndicator");
        int hCellCount = (int)(this.displayDimensions.getRatio() / 0.02f);
        int vCellCount = 50;
        float hStep = this.displayDimensions.getRatio() / (float)hCellCount;
        float vStep = 1.0f / (float)vCellCount;
        float x = hStep / 2.0f;
        float y = vStep / 2.0f;
        this.planetProximityIndicators = new ArrayList();
        for (i = 0; i < vCellCount; ++i) {
            t = new PlanetProximityIndicator(x, y, this.displayDimensions.getRatio(), 0.02f, texture);
            this.planetProximityIndicators.add(t);
            t2 = new PlanetProximityIndicator(this.displayDimensions.getRatio() - x, y, this.displayDimensions.getRatio(), 0.02f, texture);
            this.planetProximityIndicators.add(t2);
            y += vStep;
        }
        x = 0.03f;
        y = 0.01f;
        for (i = 1; i < hCellCount - 1; ++i) {
            t = new PlanetProximityIndicator(x, y, this.displayDimensions.getRatio(), 0.02f, texture);
            this.planetProximityIndicators.add(t);
            t2 = new PlanetProximityIndicator(x, 1.0f - y, this.displayDimensions.getRatio(), 0.02f, texture);
            this.planetProximityIndicators.add(t2);
            x += hStep;
        }
    }

    public void draw(UiDrawer drawer, SolApplication application) {
        float shipAngle;
        float shipSize;
        Faction shipFaction;
        SolGame game = application.getGame();
        SolCam cam = game.getCam();
        Vector2 camPosition = cam.getPosition();
        Hero hero = game.getHero();
        this.drawPlanetProximityIndicators(drawer, game, cam, camPosition);
        MapDrawer mapDrawer = game.getMapDrawer();
        FactionManager factionManager = game.getFactionMan();
        float heroDamageCap = hero.isTranscendent() ? Float.MAX_VALUE : HardnessCalc.getShipDmgCap(hero.getShip());
        List<SolObject> objects = game.getObjectManager().getObjects();
        for (SolObject solObject : objects) {
            if (solObject instanceof SolShip) {
                SolShip solShip = (SolShip)solObject;
                Vector2 shipPosition = solShip.getPosition();
                shipFaction = solShip.getPilot().getFaction();
                shipSize = solShip.getHull().config.getSize();
                shipAngle = solShip.getAngle();
                this.maybeDrawIcon(drawer, shipPosition, cam, shipSize, shipAngle, mapDrawer, factionManager, hero, shipFaction, solObject, heroDamageCap, solShip.getHull().config.getIcon());
            }
            if (!(solObject instanceof StarPort)) continue;
            StarPort starPort = (StarPort)solObject;
            this.maybeDrawIcon(drawer, starPort.getPosition(), cam, 8.0f, starPort.getAngle(), mapDrawer, null, null, null, null, -1.0f, mapDrawer.getStarPortTex());
        }
        List<FarShip> farShips = game.getObjectManager().getFarShips();
        for (FarShip farShip : farShips) {
            Vector2 shipPos = farShip.getPosition();
            shipFaction = farShip.getPilot().getFaction();
            shipSize = farShip.getHullConfig().getSize();
            shipAngle = farShip.getAngle();
            this.maybeDrawIcon(drawer, shipPos, cam, shipSize, shipAngle, mapDrawer, factionManager, hero, shipFaction, farShip, heroDamageCap, farShip.getHullConfig().getIcon());
        }
        List<StarPort.FarStarPort> list = game.getObjectManager().getFarPorts();
        for (StarPort.FarStarPort starPort : list) {
            this.maybeDrawIcon(drawer, starPort.getPosition(), cam, 8.0f, starPort.getAngle(), mapDrawer, null, null, null, null, -1.0f, mapDrawer.getStarPortTex());
        }
        this.drawWaypoints(drawer, hero.getWaypoints(), cam, mapDrawer);
    }

    private void drawWaypoints(UiDrawer uiDrawer, ArrayList<Waypoint> waypoints, SolCam cam, MapDrawer mapDrawer) {
        Vector2 camPos = cam.getPosition();
        for (Waypoint waypoint : waypoints) {
            float closeness = 1.0f - waypoint.position.dst(camPos) / 14.0f;
            float size = closeness < 0.5f ? 0.06f : 0.12f * closeness;
            Vector2 position = new Vector2();
            SolMath.toRel(waypoint.position, position, cam.getAngle(), camPos);
            float len = position.len();
            float newLen = len - 0.075f;
            position.scl(newLen / len);
            if (cam.isRelVisible(position)) continue;
            float prefX = (this.displayDimensions.getRatio() - size) / 2.0f;
            float prefY = 0.5f - size / 2.0f;
            float dimensionsRatio = prefX / prefY;
            boolean prefXAxis = position.y == 0.0f || dimensionsRatio < SolMath.abs(position.x / position.y);
            float mul = SolMath.abs(prefXAxis ? prefX / position.x : prefY / position.y);
            position.scl(mul);
            position.add(this.displayDimensions.getRatio() / 2.0f, 0.5f);
            mapDrawer.drawWaypointIcon(size, position, mapDrawer.getWaypointTexture(), uiDrawer, waypoint.color);
        }
    }

    private void maybeDrawIcon(UiDrawer drawer, Vector2 position, SolCam cam, float objSize, float objAngle, MapDrawer mapDrawer, FactionManager factionManager, Hero hero, Faction objFac, Object shipHack, float heroDmgCap, TextureAtlas.AtlasRegion icon) {
        Vector2 camPos = cam.getPosition();
        float closeness = 1.0f - position.dst(camPos) / 14.0f;
        if (closeness < 0.0f) {
            return;
        }
        float camAngle = cam.getAngle();
        SolMath.toRel(position, this.myTmpVec, camAngle, camPos);
        float len = this.myTmpVec.len();
        float newLen = len - 0.25f * objSize;
        this.myTmpVec.scl(newLen / len);
        if (cam.isRelVisible(this.myTmpVec)) {
            return;
        }
        float size = 0.12f * closeness;
        float prefX = this.displayDimensions.getRatio() / 2.0f - size / 2.0f;
        float prefY = 0.5f - size / 2.0f;
        float dimensionsRatio = prefX / prefY;
        boolean prefXAxis = this.myTmpVec.y == 0.0f || dimensionsRatio < SolMath.abs(this.myTmpVec.x / this.myTmpVec.y);
        float mul = SolMath.abs(prefXAxis ? prefX / this.myTmpVec.x : prefY / this.myTmpVec.y);
        this.myTmpVec.scl(mul);
        this.myTmpVec.add(this.displayDimensions.getRatio() / 2.0f, 0.5f);
        mapDrawer.drawObjIcon(size, this.myTmpVec, objAngle - camAngle, factionManager, hero, objFac, heroDmgCap, shipHack, icon, drawer);
    }

    private void drawPlanetProximityIndicators(UiDrawer drawer, SolGame game, SolCam cam, Vector2 camPosition) {
        PlanetManager planetManager = game.getPlanetManager();
        Planet nearestPlanet = planetManager.getNearestPlanet();
        if (nearestPlanet != null && nearestPlanet.getPosition().dst(camPosition) < nearestPlanet.getFullHeight()) {
            return;
        }
        for (PlanetProximityIndicator planetProximityIndicator : this.planetProximityIndicators) {
            planetProximityIndicator.reset();
        }
        float camAngle = cam.getAngle();
        ArrayList<Planet> planets = planetManager.getPlanets();
        for (Planet planet : planets) {
            Vector2 objPos = planet.getPosition();
            float objRad = planet.getFullHeight();
            this.apply0(camPosition, camAngle, objPos, objRad);
        }
        SolSystem sys = planetManager.getNearestSystem(camPosition);
        this.apply0(camPosition, camAngle, sys.getPosition(), 58.5f);
        for (PlanetProximityIndicator planetProximityIndicator : this.planetProximityIndicators) {
            planetProximityIndicator.draw(drawer);
        }
    }

    private void apply0(Vector2 camPos, float camAngle, Vector2 objPos, float objRad) {
        float dst = objPos.dst(camPos);
        float distPercentage = (dst - objRad) / 78.0f;
        if (distPercentage < 1.0f) {
            float relAngle = SolMath.angle(camPos, objPos) - camAngle;
            float angularWHalf = SolMath.angularWidthOfSphere(objRad, dst);
            this.apply(distPercentage, angularWHalf, relAngle);
        }
    }

    private void apply(float distPercentage, float angularWHalf, float relAngle) {
        for (PlanetProximityIndicator planetProximityIndicator : this.planetProximityIndicators) {
            if (!(SolMath.angleDiff(planetProximityIndicator.myAngle, relAngle) < angularWHalf)) continue;
            planetProximityIndicator.setDistPerc(distPercentage);
        }
    }

    private static class PlanetProximityIndicator {
        private final float myX;
        private final float myY;
        private final TextureAtlas.AtlasRegion myTexture;
        private final float myMaxSz;
        private final Color myCol;
        private final float myAngle;
        private float myPercentage;

        private PlanetProximityIndicator(float x, float y, float r, float maxSz, TextureAtlas.AtlasRegion tex) {
            this.myX = x;
            this.myY = y;
            this.myTexture = tex;
            this.myMaxSz = maxSz * 0.9f;
            Vector2 position = new Vector2(x, y);
            Vector2 centah = new Vector2(r / 2.0f, 0.5f);
            this.myAngle = SolMath.angle(centah, position);
            this.myCol = new Color(SolColor.UI_DARK);
        }

        private void draw(UiDrawer drawer) {
            float sz = this.myPercentage * this.myMaxSz;
            this.myCol.a = this.myPercentage;
            drawer.draw((TextureRegion)this.myTexture, sz, sz, sz / 2.0f, sz / 2.0f, this.myX, this.myY, 0.0f, this.myCol);
        }

        private void setDistPerc(float distPercentage) {
            float closeness = 1.0f - distPercentage;
            if (closeness < this.myPercentage) {
                return;
            }
            this.myPercentage = closeness;
        }

        private void reset() {
            this.myPercentage = 0.0f;
        }
    }
}

