/*
 * Decompiled with CFR 0.152.
 */
package org.destinationsol.game.screens;

import org.destinationsol.GameOptions;
import org.destinationsol.SolApplication;
import org.destinationsol.game.FactionInfo;
import org.destinationsol.game.Hero;
import org.destinationsol.game.SolGame;
import org.destinationsol.game.item.ItemContainer;
import org.destinationsol.game.item.SolItem;
import org.destinationsol.game.screens.InventoryOperationsScreen;
import org.destinationsol.game.screens.InventoryScreen;
import org.destinationsol.game.screens.TalkScreen;
import org.destinationsol.game.ship.SolShip;
import org.destinationsol.ui.SolInputManager;
import org.destinationsol.ui.SolUiControl;

public class BuyItemsScreen
extends InventoryOperationsScreen {
    public final SolUiControl buyControl;

    BuyItemsScreen(InventoryScreen inventoryScreen, GameOptions gameOptions) {
        this.buyControl = new SolUiControl(inventoryScreen.itemCtrl(0), true, gameOptions.getKeyBuyItem());
        this.buyControl.setDisplayName("Buy");
        this.controls.add(this.buyControl);
    }

    @Override
    public ItemContainer getItems(SolGame game) {
        return game.getScreens().talkScreen.getTarget().getTradeContainer().getItems();
    }

    @Override
    public String getHeader() {
        return "Buy:";
    }

    @Override
    public void updateCustom(SolApplication solApplication, SolInputManager.InputPointer[] inputPointers, boolean clickedOutside) {
        SolGame game = solApplication.getGame();
        InventoryScreen is = game.getScreens().inventoryScreen;
        Hero hero = game.getHero();
        TalkScreen talkScreen = game.getScreens().talkScreen;
        SolShip target = talkScreen.getTarget();
        if (talkScreen.isTargetFar(hero)) {
            solApplication.getInputManager().setScreen(solApplication, game.getScreens().mainGameScreen);
            return;
        }
        SolItem selItem = is.getSelectedItem();
        boolean enabled = selItem != null && hero.getMoney() >= selItem.getPrice() && hero.getItemContainer().canAdd(selItem);
        this.buyControl.setDisplayName(enabled ? "Buy" : "---");
        this.buyControl.setEnabled(enabled);
        if (!enabled) {
            return;
        }
        if (this.buyControl.isJustOff()) {
            target.getTradeContainer().getItems().remove(selItem);
            hero.getItemContainer().add(selItem);
            hero.setMoney(hero.getMoney() - selItem.getPrice());
            FactionInfo.setDisposition(target.getFactionID(), 1);
        }
    }
}

