/*
 * Decompiled with CFR 0.152.
 */
package org.destinationsol.game.screens;

import com.badlogic.gdx.math.Vector2;
import org.destinationsol.GameOptions;
import org.destinationsol.SolApplication;
import org.destinationsol.game.Hero;
import org.destinationsol.game.SolGame;
import org.destinationsol.game.item.Engine;
import org.destinationsol.game.item.Gun;
import org.destinationsol.game.item.ItemContainer;
import org.destinationsol.game.item.ShipItem;
import org.destinationsol.game.item.SolItem;
import org.destinationsol.game.screens.InventoryOperationsScreen;
import org.destinationsol.game.screens.InventoryScreen;
import org.destinationsol.game.screens.TalkScreen;
import org.destinationsol.game.ship.ShipRepairer;
import org.destinationsol.game.ship.SolShip;
import org.destinationsol.game.ship.hulls.Hull;
import org.destinationsol.game.ship.hulls.HullConfig;
import org.destinationsol.ui.SolInputManager;
import org.destinationsol.ui.SolUiControl;

public class ChangeShipScreen
extends InventoryOperationsScreen {
    private final SolUiControl changeControl;

    ChangeShipScreen(InventoryScreen inventoryScreen, GameOptions gameOptions) {
        this.changeControl = new SolUiControl(inventoryScreen.itemCtrl(0), true, gameOptions.getKeyChangeShip());
        this.changeControl.setDisplayName("Change");
        this.controls.add(this.changeControl);
    }

    @Override
    public ItemContainer getItems(SolGame game) {
        return game.getScreens().talkScreen.getTarget().getTradeContainer().getShips();
    }

    @Override
    public String getHeader() {
        return "Ships:";
    }

    @Override
    public void updateCustom(SolApplication solApplication, SolInputManager.InputPointer[] inputPointers, boolean clickedOutside) {
        SolGame game = solApplication.getGame();
        InventoryScreen is = game.getScreens().inventoryScreen;
        TalkScreen talkScreen = game.getScreens().talkScreen;
        Hero hero = game.getHero();
        if (talkScreen.isTargetFar(hero)) {
            solApplication.getInputManager().setScreen(solApplication, game.getScreens().mainGameScreen);
            return;
        }
        SolItem selItem = is.getSelectedItem();
        if (selItem == null) {
            this.changeControl.setDisplayName("---");
            this.changeControl.setEnabled(false);
            return;
        }
        boolean enabled = this.hasMoneyToBuyShip(hero, selItem);
        boolean sameShip = this.isSameShip(hero, selItem);
        if (!enabled || sameShip) {
            if (enabled && sameShip) {
                this.changeControl.setDisplayName("Have it");
                this.changeControl.setEnabled(false);
                return;
            }
            this.changeControl.setDisplayName("---");
            this.changeControl.setEnabled(false);
            return;
        }
        this.changeControl.setDisplayName("Change");
        this.changeControl.setEnabled(true);
        if (this.changeControl.isJustOff()) {
            hero.setMoney(hero.getMoney() - selItem.getPrice());
            this.changeShip(game, hero, (ShipItem)selItem);
        }
    }

    private boolean hasMoneyToBuyShip(Hero hero, SolItem shipToBuy) {
        return hero.getMoney() >= shipToBuy.getPrice();
    }

    private boolean isSameShip(Hero hero, SolItem shipToBuy) {
        if (shipToBuy instanceof ShipItem) {
            ShipItem ship = (ShipItem)shipToBuy;
            HullConfig config1 = ship.getConfig();
            HullConfig config2 = hero.getHull().getHullConfig();
            return config1.equals(config2);
        }
        throw new IllegalArgumentException("ChangeShipScreen:isSameShip received " + shipToBuy.getClass() + " argument instead of ShipItem!");
    }

    private void changeShip(SolGame game, Hero hero, ShipItem selected) {
        HullConfig newConfig = selected.getConfig();
        Hull hull = hero.getHull();
        Engine.Config ec = newConfig.getEngineConfig();
        Engine ei = ec == null ? null : ec.exampleEngine.copy();
        Gun g2 = hull.getGun(true);
        SolShip newHero = game.getShipBuilder().build(game, hero.getPosition(), new Vector2(), hero.getAngle(), 0.0f, hero.getPilot(), hero.getItemContainer(), newConfig, newConfig.getMaxLife(), hull.getGun(false), g2, null, ei, new ShipRepairer(), hero.getMoney(), null, hero.getShield(), hero.getArmor());
        game.getObjectManager().removeObjDelayed(hero.getShip());
        game.getObjectManager().addObjDelayed(newHero);
        game.getHero().setSolShip(newHero, game);
    }
}

