/*
 * Decompiled with CFR 0.152.
 */
package org.destinationsol.game.screens;

import org.destinationsol.GameOptions;
import org.destinationsol.SolApplication;
import org.destinationsol.game.SolGame;
import org.destinationsol.game.item.ItemContainer;
import org.destinationsol.game.item.MercItem;
import org.destinationsol.game.item.SolItem;
import org.destinationsol.game.screens.GameScreens;
import org.destinationsol.game.screens.InventoryOperationsScreen;
import org.destinationsol.game.screens.InventoryScreen;
import org.destinationsol.game.ship.SolShip;
import org.destinationsol.ui.SolInputManager;
import org.destinationsol.ui.SolUiControl;

public class ChooseMercenaryScreen
extends InventoryOperationsScreen {
    private final SolUiControl giveControl;
    private final SolUiControl takeControl;
    private final SolUiControl equipControl;
    private final ItemContainer EMPTY_ITEM_CONTAINER = new ItemContainer();

    ChooseMercenaryScreen(InventoryScreen inventoryScreen, GameOptions gameOptions) {
        this.giveControl = new SolUiControl(inventoryScreen.itemCtrl(0), true, gameOptions.getKeyShoot());
        this.giveControl.setDisplayName("Give Items");
        this.controls.add(this.giveControl);
        this.takeControl = new SolUiControl(inventoryScreen.itemCtrl(1), true, gameOptions.getKeyShoot2());
        this.takeControl.setDisplayName("Take Items");
        this.controls.add(this.takeControl);
        this.equipControl = new SolUiControl(inventoryScreen.itemCtrl(2), true, gameOptions.getKeyDrop());
        this.equipControl.setDisplayName("Equip Items");
        this.controls.add(this.equipControl);
    }

    @Override
    public void updateCustom(SolApplication solApplication, SolInputManager.InputPointer[] inputPointers, boolean clickedOutside) {
        SolGame game = solApplication.getGame();
        InventoryScreen is = game.getScreens().inventoryScreen;
        SolInputManager inputMan = solApplication.getInputManager();
        GameScreens screens = game.getScreens();
        SolItem selItem = is.getSelectedItem();
        boolean selNull = selItem != null;
        this.giveControl.setEnabled(selNull);
        this.takeControl.setEnabled(selNull);
        this.equipControl.setEnabled(selNull);
        if (this.giveControl.isJustOff() && selNull) {
            SolShip solship = ((MercItem)selItem).getSolShip();
            inputMan.setScreen(solApplication, screens.mainGameScreen);
            is.giveItemsScreen.setTarget(solship);
            is.setOperations(is.giveItemsScreen);
            inputMan.addScreen(solApplication, is);
        } else if (this.takeControl.isJustOff() && selNull) {
            SolShip solship = ((MercItem)selItem).getSolShip();
            inputMan.setScreen(solApplication, screens.mainGameScreen);
            is.takeItems.setTarget(solship);
            is.setOperations(is.takeItems);
            inputMan.addScreen(solApplication, is);
        } else if (this.equipControl.isJustOff() && selNull) {
            SolShip solship = ((MercItem)selItem).getSolShip();
            inputMan.setScreen(solApplication, screens.mainGameScreen);
            is.showInventory.setTarget(solship);
            is.setOperations(is.showInventory);
            inputMan.addScreen(solApplication, is);
        }
    }

    @Override
    public ItemContainer getItems(SolGame game) {
        ItemContainer mercs;
        if (game.getHero().isNonTranscendent() && (mercs = game.getHero().getMercs()) != null) {
            return mercs;
        }
        return this.EMPTY_ITEM_CONTAINER;
    }

    @Override
    public String getHeader() {
        return "Mercenaries:";
    }
}

