/*
 * Decompiled with CFR 0.152.
 */
package org.destinationsol.game.screens;

import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.physics.box2d.Fixture;
import com.badlogic.gdx.physics.box2d.RayCastCallback;
import org.destinationsol.common.SolMath;
import org.destinationsol.game.Hero;
import org.destinationsol.game.SolGame;
import org.destinationsol.game.SolObject;
import org.destinationsol.game.screens.WarnDrawer;

public class CollisionWarnDrawer
extends WarnDrawer {
    private final CollisionRayCastCallback warnCallback = new CollisionRayCastCallback();
    private Hero hero;

    CollisionWarnDrawer() {
        super("Object Near");
    }

    @Override
    public boolean shouldWarn(SolGame game) {
        this.hero = game.getHero();
        if (this.hero.isTranscendent()) {
            return false;
        }
        Vector2 position = this.hero.getPosition();
        Vector2 velocity = this.hero.getVelocity();
        float acc = this.hero.getAcceleration();
        float speed = velocity.len();
        float velocityAngle = SolMath.angle(velocity);
        if (acc <= 0.0f || speed < 2.0f * acc) {
            return false;
        }
        float breakWay = speed * speed / acc / 2.0f;
        Vector2 finalPos = SolMath.getVec(0.0f, 0.0f);
        SolMath.fromAl(finalPos, velocityAngle, breakWay += 2.0f * speed);
        finalPos.add(position);
        this.warnCallback.show = false;
        game.getObjectManager().getWorld().rayCast((RayCastCallback)this.warnCallback, position, finalPos);
        SolMath.free(finalPos);
        return this.warnCallback.show;
    }

    private class CollisionRayCastCallback
    implements RayCastCallback {
        private boolean show;

        private CollisionRayCastCallback() {
        }

        public float reportRayFixture(Fixture fixture, Vector2 point, Vector2 normal, float fraction) {
            SolObject o = (SolObject)fixture.getBody().getUserData();
            if (CollisionWarnDrawer.this.hero == o) {
                return -1.0f;
            }
            this.show = true;
            return 0.0f;
        }
    }
}

