/*
 * Decompiled with CFR 0.152.
 */
package org.destinationsol.game.screens;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.BitmapFont;
import com.badlogic.gdx.math.Rectangle;
import com.badlogic.gdx.math.Vector2;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import org.destinationsol.SolApplication;
import org.destinationsol.assets.Assets;
import org.destinationsol.common.SolColor;
import org.destinationsol.game.SolGame;
import org.destinationsol.game.console.Console;
import org.destinationsol.game.console.ConsoleImpl;
import org.destinationsol.game.console.ConsoleSubscriber;
import org.destinationsol.game.console.CoreMessageType;
import org.destinationsol.game.console.CyclingTabCompletionEngine;
import org.destinationsol.game.console.Message;
import org.destinationsol.game.console.TabCompletionEngine;
import org.destinationsol.game.context.Context;
import org.destinationsol.ui.SolInputManager;
import org.destinationsol.ui.SolUiControl;
import org.destinationsol.ui.SolUiScreen;
import org.destinationsol.ui.UiDrawer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConsoleScreen
implements SolUiScreen,
ConsoleSubscriber {
    private static final Logger logger = LoggerFactory.getLogger(ConsoleScreen.class);
    private static final Vector2 TOP_LEFT = new Vector2(0.03f, 0.03f);
    private static final Vector2 BOTTOM_RIGHT = new Vector2(0.8f, 0.5f);
    private static final float FRAME_WIDTH = 0.02f;
    private static final float INPUT_LINE_Y = 20.666f;
    private static final float INPUT_LINE_SEPARATOR_Y = 20.333f;
    private Console console;
    private static ConsoleScreen instance;
    private boolean welcomePrinted;
    private boolean isActive;
    public final BitmapFont font = Assets.getFont("engine:main").getBitmapFont();
    private final SolUiControl exitControl;
    private final SolUiControl commandHistoryUpControl;
    private final SolUiControl commandHistoryDownControl;
    private final List<SolUiControl> controls;
    private int commandHistoryIndex;
    private TabCompletionEngine completionEngine;
    private StringBuilder inputLine;

    public ConsoleScreen(Context context) {
        this.console = new ConsoleImpl(this.font, context);
        this.exitControl = new SolUiControl(null, true, 131);
        this.commandHistoryUpControl = new SolUiControl(null, true, 19);
        this.commandHistoryDownControl = new SolUiControl(null, true, 20);
        this.controls = new ArrayList<SolUiControl>();
        this.controls.add(this.exitControl);
        this.controls.add(this.commandHistoryUpControl);
        this.controls.add(this.commandHistoryDownControl);
        this.inputLine = new StringBuilder();
        instance = this;
        this.completionEngine = new CyclingTabCompletionEngine(this.console);
        this.commandHistoryIndex = this.console.getPreviousCommands().size();
        this.welcomePrinted = false;
    }

    public void init(SolGame game) {
        this.console.init(game);
    }

    public static Optional<ConsoleScreen> getInstance() {
        if (instance == null) {
            return Optional.empty();
        }
        return Optional.of(instance);
    }

    @Override
    public List<SolUiControl> getControls() {
        return this.controls;
    }

    @Override
    public void onAdd(SolApplication solApplication) {
        this.isActive = true;
        if (!this.welcomePrinted) {
            this.console.addMessage("Welcome to the world of Destination Sol! Your journey begins!\nType 'help' to see a list with available commands or 'help <commandName>' for command details.\nText parameters do not need quotes, unless containing spaces. No commas between parameters.\nYou can use auto-completion by typing a partial command then hitting [tab] - examples:\n\ngo + [tab] => 'godMode'\nhelp gh + [tab] => 'help godMode' (can auto complete commands fed to help)\n(use [tab] again to cycle between choices)\ngM + [tab] => 'godMode' (camel casing abbreviated commands)\n");
            this.welcomePrinted = true;
        }
    }

    @Override
    public void updateCustom(SolApplication solApplication, SolInputManager.InputPointer[] inputPointers, boolean clickedOutside) {
        if (this.exitControl.isJustOff()) {
            solApplication.getInputManager().setScreen(solApplication, solApplication.getGame().getScreens().mainGameScreen);
        }
        if (this.commandHistoryUpControl.isJustOff()) {
            if (this.commandHistoryIndex > 0) {
                --this.commandHistoryIndex;
                this.inputLine = new StringBuilder();
                this.inputLine.append(this.console.getPreviousCommands().get(this.commandHistoryIndex));
            }
        } else if (this.commandHistoryDownControl.isJustOff() && this.commandHistoryIndex < this.console.getPreviousCommands().size()) {
            ++this.commandHistoryIndex;
            if (this.commandHistoryIndex == this.console.getPreviousCommands().size()) {
                this.inputLine = new StringBuilder();
            } else {
                this.inputLine = new StringBuilder();
                this.inputLine.append(this.console.getPreviousCommands().get(this.commandHistoryIndex));
            }
        }
    }

    @Override
    public boolean isCursorOnBackground(SolInputManager.InputPointer inputPointer) {
        return false;
    }

    @Override
    public void blurCustom(SolApplication solApplication) {
        this.isActive = false;
    }

    @Override
    public void drawBackground(UiDrawer uiDrawer, SolApplication solApplication) {
        this.drawFrame(uiDrawer);
        this.drawTextEntrySeparator(uiDrawer);
    }

    private void drawFrame(UiDrawer uiDrawer) {
        uiDrawer.draw(new Rectangle(ConsoleScreen.TOP_LEFT.x, ConsoleScreen.TOP_LEFT.y, ConsoleScreen.BOTTOM_RIGHT.x - ConsoleScreen.TOP_LEFT.x, ConsoleScreen.BOTTOM_RIGHT.y - ConsoleScreen.TOP_LEFT.y), SolColor.UI_LIGHT);
        uiDrawer.draw(new Rectangle(ConsoleScreen.TOP_LEFT.x + 0.02f, ConsoleScreen.TOP_LEFT.y + 0.02f, ConsoleScreen.BOTTOM_RIGHT.x - ConsoleScreen.TOP_LEFT.x - 0.04f, ConsoleScreen.BOTTOM_RIGHT.y - ConsoleScreen.TOP_LEFT.y - 0.04f), SolColor.UI_BG_LIGHT);
    }

    private void drawTextEntrySeparator(UiDrawer uiDrawer) {
        uiDrawer.drawLine(ConsoleScreen.TOP_LEFT.x + 0.04f, this.getLineY(20.333f), 0.0f, ConsoleScreen.BOTTOM_RIGHT.x - ConsoleScreen.TOP_LEFT.x - 0.08f, Color.WHITE);
    }

    @Override
    public void drawText(UiDrawer uiDrawer, SolApplication solApplication) {
        float textX = ConsoleScreen.TOP_LEFT.x + 0.04f;
        Iterator<Message> iterator = this.console.getMessages().iterator();
        for (int lineNumber = 0; iterator.hasNext() && lineNumber < 20; ++lineNumber) {
            Message message = iterator.next();
            uiDrawer.drawString(message.getMessage(), textX, this.getLineY(lineNumber), 0.5f, UiDrawer.TextAlignment.LEFT, false, message.getType().getColor());
        }
        this.drawInputLine(uiDrawer, textX);
    }

    private void drawInputLine(UiDrawer uiDrawer, float textX) {
        StringBuilder stringBuilder = new StringBuilder();
        if (System.currentTimeMillis() % 2000L > 1000L) {
            stringBuilder.append('_');
        }
        int width = this.font.getData().getGlyph((char)'_').width;
        for (char c : this.inputLine.reverse().toString().toCharArray()) {
            BitmapFont.Glyph glyph = this.font.getData().getGlyph(c);
            if (glyph != null) {
                if ((width += glyph.width < 10 ? 10 : glyph.width) > 1040) break;
                stringBuilder.append(c);
                continue;
            }
            this.inputLine.deleteCharAt(0);
        }
        uiDrawer.drawString(stringBuilder.reverse().toString(), textX, this.getLineY(20.666f), 0.5f, UiDrawer.TextAlignment.LEFT, false, Color.WHITE);
        this.inputLine.reverse();
    }

    @Override
    public void onNewConsoleMessage(Message message) {
    }

    public void onCharEntered(char character) {
        if (this.isActive) {
            if (character == '\t' && this.inputLine.length() > 0) {
                this.inputLine = new StringBuilder(this.completionEngine.complete(this.inputLine.toString()));
            } else if (character != '\t') {
                this.completionEngine.reset();
            }
            if (character == '\r' || character == '\n') {
                this.console.addMessage("> " + this.inputLine.toString(), CoreMessageType.WARN);
                this.console.execute(this.inputLine.toString());
                this.inputLine = new StringBuilder();
                this.commandHistoryIndex = this.console.getPreviousCommands().size();
                return;
            }
            if (character == '\b') {
                if (this.inputLine.length() != 0) {
                    this.inputLine.deleteCharAt(this.inputLine.length() - 1);
                }
                return;
            }
            this.inputLine.append(character);
        }
    }

    private float getLineY(float line) {
        return ConsoleScreen.TOP_LEFT.y + 0.04f + line * 0.02f * 0.5f * 1.8f;
    }

    public Console getConsole() {
        return this.console;
    }
}

