/*
 * Decompiled with CFR 0.152.
 */
package org.destinationsol.game.screens;

import org.destinationsol.GameOptions;
import org.destinationsol.SolApplication;
import org.destinationsol.game.Hero;
import org.destinationsol.game.SolGame;
import org.destinationsol.game.item.ItemContainer;
import org.destinationsol.game.item.SolItem;
import org.destinationsol.game.screens.InventoryOperationsScreen;
import org.destinationsol.game.screens.InventoryScreen;
import org.destinationsol.game.ship.SolShip;
import org.destinationsol.ui.SolInputManager;
import org.destinationsol.ui.SolUiControl;

public class GiveItemsScreen
extends InventoryOperationsScreen {
    private final SolUiControl giveControl;
    private SolShip target;

    GiveItemsScreen(InventoryScreen inventoryScreen, GameOptions gameOptions) {
        this.giveControl = new SolUiControl(inventoryScreen.itemCtrl(0), true, gameOptions.getKeySellItem());
        this.giveControl.setDisplayName("Give");
        this.controls.add(this.giveControl);
    }

    @Override
    public ItemContainer getItems(SolGame game) {
        Hero hero = game.getHero();
        return hero.getItemContainer();
    }

    @Override
    public boolean isUsing(SolGame game, SolItem item) {
        Hero hero = game.getHero();
        return hero.isNonTranscendent() && hero.maybeUnequip(game, item, false);
    }

    @Override
    public String getHeader() {
        return "Give:";
    }

    @Override
    public void updateCustom(SolApplication solApplication, SolInputManager.InputPointer[] inputPointers, boolean clickedOutside) {
        SolGame game = solApplication.getGame();
        InventoryScreen inventoryScreen = game.getScreens().inventoryScreen;
        Hero hero = game.getHero();
        SolItem selItem = inventoryScreen.getSelectedItem();
        if (selItem == null) {
            this.giveControl.setDisplayName("----");
            this.giveControl.setEnabled(false);
            return;
        }
        boolean isWornAndCanBeGiven = this.isItemEquippedAndGiveable(selItem, solApplication.getOptions());
        boolean enabled = this.isItemGiveable(selItem, this.target);
        if (enabled && isWornAndCanBeGiven) {
            this.giveControl.setDisplayName("Give");
            this.giveControl.setEnabled(true);
        } else if (enabled) {
            this.giveControl.setDisplayName("Unequip it!");
            this.giveControl.setEnabled(false);
        } else {
            this.giveControl.setDisplayName("----");
            this.giveControl.setEnabled(false);
        }
        if (!enabled || !isWornAndCanBeGiven) {
            return;
        }
        if (this.giveControl.isJustOff()) {
            ItemContainer itemContainer = hero.getItemContainer();
            inventoryScreen.setSelected(itemContainer.getSelectionAfterRemove(inventoryScreen.getSelected()));
            itemContainer.remove(selItem);
            this.target.getItemContainer().add(selItem);
        }
    }

    private boolean isItemGiveable(SolItem item, SolShip target) {
        return target.getItemContainer().canAdd(item);
    }

    private boolean isItemEquippedAndGiveable(SolItem item, GameOptions options) {
        return item.isEquipped() == 0 || options.canSellEquippedItems;
    }

    public void setTarget(SolShip solship) {
        this.target = solship;
    }
}

