/*
 * Decompiled with CFR 0.152.
 */
package org.destinationsol.game.screens;

import org.destinationsol.GameOptions;
import org.destinationsol.SolApplication;
import org.destinationsol.game.Hero;
import org.destinationsol.game.SolGame;
import org.destinationsol.game.item.ItemContainer;
import org.destinationsol.game.item.MercItem;
import org.destinationsol.game.item.SolItem;
import org.destinationsol.game.screens.InventoryOperationsScreen;
import org.destinationsol.game.screens.InventoryScreen;
import org.destinationsol.game.screens.TalkScreen;
import org.destinationsol.mercenary.MercenaryUtils;
import org.destinationsol.ui.SolInputManager;
import org.destinationsol.ui.SolUiControl;

public class HireShipsScreen
extends InventoryOperationsScreen {
    private final SolUiControl hireControl;

    HireShipsScreen(InventoryScreen inventoryScreen, GameOptions gameOptions) {
        this.hireControl = new SolUiControl(inventoryScreen.itemCtrl(0), true, gameOptions.getKeyHireShip());
        this.hireControl.setDisplayName("Hire");
        this.controls.add(this.hireControl);
    }

    @Override
    public ItemContainer getItems(SolGame game) {
        return game.getScreens().talkScreen.getTarget().getTradeContainer().getMercs();
    }

    @Override
    public String getHeader() {
        return "Mercenaries:";
    }

    @Override
    public void updateCustom(SolApplication solApplication, SolInputManager.InputPointer[] inputPointers, boolean clickedOutside) {
        boolean hired;
        SolGame game = solApplication.getGame();
        InventoryScreen is = game.getScreens().inventoryScreen;
        TalkScreen talkScreen = game.getScreens().talkScreen;
        Hero hero = game.getHero();
        if (talkScreen.isTargetFar(hero)) {
            solApplication.getInputManager().setScreen(solApplication, game.getScreens().mainGameScreen);
            return;
        }
        SolItem selItem = is.getSelectedItem();
        boolean enabled = selItem != null && hero.getMoney() >= selItem.getPrice();
        this.hireControl.setDisplayName(enabled ? "Hire" : "---");
        this.hireControl.setEnabled(enabled);
        if (!enabled) {
            return;
        }
        if (this.hireControl.isJustOff() && (hired = MercenaryUtils.createMerc(game, hero, (MercItem)selItem))) {
            hero.setMoney(hero.getMoney() - selItem.getPrice());
        }
    }
}

