/*
 * Decompiled with CFR 0.152.
 */
package org.destinationsol.game.screens;

import com.badlogic.gdx.graphics.g2d.TextureAtlas;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.math.Rectangle;
import com.badlogic.gdx.math.Vector2;
import java.util.ArrayList;
import java.util.List;
import org.destinationsol.GameOptions;
import org.destinationsol.SolApplication;
import org.destinationsol.common.SolColor;
import org.destinationsol.game.SolGame;
import org.destinationsol.game.item.ItemContainer;
import org.destinationsol.game.item.SolItem;
import org.destinationsol.game.screens.BuyItemsScreen;
import org.destinationsol.game.screens.ChangeShipScreen;
import org.destinationsol.game.screens.ChooseMercenaryScreen;
import org.destinationsol.game.screens.GameScreens;
import org.destinationsol.game.screens.GiveItemsScreen;
import org.destinationsol.game.screens.HireShipsScreen;
import org.destinationsol.game.screens.InventoryOperationsScreen;
import org.destinationsol.game.screens.SellItems;
import org.destinationsol.game.screens.ShowInventory;
import org.destinationsol.game.screens.TakeItems;
import org.destinationsol.ui.DisplayDimensions;
import org.destinationsol.ui.SolInputManager;
import org.destinationsol.ui.SolUiBaseScreen;
import org.destinationsol.ui.SolUiControl;
import org.destinationsol.ui.UiDrawer;

public class InventoryScreen
extends SolUiBaseScreen {
    private static final ItemContainer EMPTY_CONTAINER = new ItemContainer();
    private static final float HEADER_TEXT_OFFSET = 0.005f;
    private static final float SMALL_GAP = 0.004f;
    private static final int BUTTON_ROWS = 4;
    private static final float IMG_COL_PERC = 0.1f;
    private static final float EQUI_COL_PERC = 0.1f;
    private static final float PRICE_COL_PERC = 0.1f;
    private static final float AMT_COL_PERC = 0.1f;
    public final ShowInventory showInventory;
    public final BuyItemsScreen buyItemsScreen;
    public final SellItems sellItems;
    public final ChangeShipScreen changeShipScreen;
    public final HireShipsScreen hireShipsScreen;
    public final ChooseMercenaryScreen chooseMercenaryScreen;
    public final GiveItemsScreen giveItemsScreen;
    public final TakeItems takeItems;
    public final SolUiControl[] itemControls;
    private final SolUiControl previousControl;
    private final SolUiControl upControl;
    public final SolUiControl nextControl;
    public final SolUiControl closeControl;
    public final SolUiControl downControl;
    private final Rectangle myArea;
    private final Rectangle myListArea;
    private final Rectangle myDetailArea;
    private final Rectangle myItemCtrlArea;
    private final Vector2 myDetailHeaderPos;
    private final Vector2 myListHeaderPos;
    private int myPage;
    private List<SolItem> mySelected;
    private InventoryOperationsScreen myOperations;

    public InventoryScreen(GameOptions gameOptions) {
        float row0;
        DisplayDimensions displayDimensions = SolApplication.displayDimensions;
        float contentW = 0.8f;
        float col0 = displayDimensions.getRatio() / 2.0f - contentW / 2.0f;
        float row = row0 = 0.2f;
        float backgroundGap = 0.03f;
        float bigGap = 0.024f;
        float headerH = 0.03f;
        this.myListHeaderPos = new Vector2(col0 + 0.005f, row + 0.005f);
        float listCtrlW = contentW * 0.15f;
        Rectangle nextArea = new Rectangle(col0 + contentW - listCtrlW, row, listCtrlW, headerH);
        this.nextControl = new SolUiControl(nextArea, true, gameOptions.getKeyRight());
        this.nextControl.setDisplayName(">");
        this.controls.add(this.nextControl);
        Rectangle prevArea = new Rectangle(nextArea.x - 0.004f - listCtrlW, row, listCtrlW, headerH);
        this.previousControl = new SolUiControl(prevArea, true, gameOptions.getKeyLeft());
        this.previousControl.setDisplayName("<");
        this.controls.add(this.previousControl);
        float itemRowH = 0.04f;
        float listRow0 = row += headerH + 0.004f;
        this.itemControls = new SolUiControl[8];
        for (int i = 0; i < 8; ++i) {
            SolUiControl itemCtrl;
            Rectangle itemR = new Rectangle(col0, row, contentW, itemRowH);
            this.itemControls[i] = itemCtrl = new SolUiControl(itemR, true, new int[0]);
            this.controls.add(itemCtrl);
            row += itemRowH + 0.004f;
        }
        this.myListArea = new Rectangle(col0, row, contentW, row - 0.004f - listRow0);
        this.myDetailHeaderPos = new Vector2(col0 + 0.005f, (row += bigGap) + 0.005f);
        float itemCtrlAreaW = contentW * 0.4f;
        this.myItemCtrlArea = new Rectangle(col0 + contentW - itemCtrlAreaW, row += headerH + 0.004f, itemCtrlAreaW, 0.2f);
        this.myDetailArea = new Rectangle(col0, row, contentW - itemCtrlAreaW - 0.004f, this.myItemCtrlArea.height);
        this.myArea = new Rectangle(col0 - backgroundGap, row0 - backgroundGap, contentW + backgroundGap * 2.0f, (row += this.myDetailArea.height) - row0 + backgroundGap * 2.0f);
        this.closeControl = new SolUiControl(this.itemCtrl(3), true, gameOptions.getKeyClose());
        this.closeControl.setDisplayName("Close");
        this.controls.add(this.closeControl);
        this.showInventory = new ShowInventory(this, gameOptions);
        this.buyItemsScreen = new BuyItemsScreen(this, gameOptions);
        this.sellItems = new SellItems(this, gameOptions);
        this.changeShipScreen = new ChangeShipScreen(this, gameOptions);
        this.hireShipsScreen = new HireShipsScreen(this, gameOptions);
        this.chooseMercenaryScreen = new ChooseMercenaryScreen(this, gameOptions);
        this.giveItemsScreen = new GiveItemsScreen(this, gameOptions);
        this.takeItems = new TakeItems(this, gameOptions);
        this.upControl = new SolUiControl(null, true, gameOptions.getKeyUp());
        this.controls.add(this.upControl);
        this.downControl = new SolUiControl(null, true, gameOptions.getKeyDown());
        this.controls.add(this.downControl);
    }

    @Override
    public void updateCustom(SolApplication solApplication, SolInputManager.InputPointer[] inputPointers, boolean clickedOutside) {
        int groupCount;
        int pageCount;
        ItemContainer itemContainer;
        if (clickedOutside) {
            this.closeControl.maybeFlashPressed(solApplication.getOptions().getKeyClose());
            return;
        }
        if (this.closeControl.isJustOff()) {
            SolGame game = solApplication.getGame();
            if (this.myOperations == this.giveItemsScreen || this.myOperations == this.takeItems || this.myOperations == this.showInventory && this.showInventory.getTarget() != game.getHero().getShip()) {
                SolInputManager inputMan = solApplication.getInputManager();
                GameScreens screens = game.getScreens();
                InventoryScreen is = screens.inventoryScreen;
                inputMan.setScreen(solApplication, screens.mainGameScreen);
                is.setOperations(is.chooseMercenaryScreen);
                inputMan.addScreen(solApplication, is);
            }
            solApplication.getInputManager().setScreen(solApplication, solApplication.getGame().getScreens().mainGameScreen);
            return;
        }
        if (this.previousControl.isJustOff()) {
            --this.myPage;
        }
        if (this.nextControl.isJustOff()) {
            ++this.myPage;
        }
        if ((itemContainer = this.myOperations.getItems(solApplication.getGame())) == null) {
            itemContainer = EMPTY_CONTAINER;
        }
        if ((pageCount = (groupCount = itemContainer.groupCount()) / 8) == 0 || pageCount * 8 < groupCount) {
            ++pageCount;
        }
        if (this.myPage < 0) {
            this.myPage = 0;
        }
        if (this.myPage >= pageCount) {
            this.myPage = pageCount - 1;
        }
        this.previousControl.setEnabled(0 < this.myPage);
        this.nextControl.setEnabled(this.myPage < pageCount - 1);
        if (!itemContainer.containsGroup(this.mySelected)) {
            this.mySelected = null;
        }
        int selIdx = -1;
        int offset = this.myPage * 8;
        boolean hNew = this.showingHeroItems(solApplication);
        for (int i = 0; i < this.itemControls.length; ++i) {
            SolUiControl itemCtrl = this.itemControls[i];
            int groupIdx = offset + i;
            boolean ctrlEnabled = groupIdx < groupCount;
            itemCtrl.setEnabled(ctrlEnabled);
            if (!ctrlEnabled) continue;
            List<SolItem> group = itemContainer.getGroup(groupIdx);
            if (hNew && itemContainer.isNew(group)) {
                itemCtrl.enableWarn();
            }
            if (itemCtrl.isJustOff()) {
                this.mySelected = group;
            }
            if (this.mySelected != group) continue;
            selIdx = groupIdx;
        }
        if (selIdx < 0 && groupCount > 0) {
            this.mySelected = itemContainer.getGroup(offset);
        }
        if (this.upControl.isJustOff() && selIdx > 0) {
            this.mySelected = itemContainer.getGroup(--selIdx);
            if (selIdx < offset) {
                --this.myPage;
            }
        }
        if (this.downControl.isJustOff() && selIdx < groupCount - 1) {
            this.mySelected = itemContainer.getGroup(++selIdx);
            if (selIdx >= offset + 8) {
                ++this.myPage;
            }
        }
        if (this.mySelected != null) {
            itemContainer.seen(this.mySelected);
        }
    }

    @Override
    public boolean isCursorOnBackground(SolInputManager.InputPointer inputPointer) {
        return this.myArea.contains(inputPointer.x, inputPointer.y);
    }

    @Override
    public void onAdd(SolApplication solApplication) {
        if (this.myOperations != null) {
            solApplication.getInputManager().addScreen(solApplication, this.myOperations);
        }
        this.myPage = 0;
        this.mySelected = null;
    }

    @Override
    public void drawBackground(UiDrawer uiDrawer, SolApplication solApplication) {
        uiDrawer.draw(this.myArea, SolColor.UI_BG);
    }

    @Override
    public void drawImages(UiDrawer uiDrawer, SolApplication solApplication) {
        float rowH;
        float imgColW;
        SolGame game = solApplication.getGame();
        ItemContainer itemContainer = this.myOperations.getItems(game);
        if (itemContainer == null) {
            itemContainer = EMPTY_CONTAINER;
        }
        float imgSz = (imgColW = this.myListArea.width * 0.1f) < (rowH = this.itemControls[0].getScreenArea().height) ? imgColW : rowH;
        uiDrawer.draw(this.myDetailArea, SolColor.UI_INACTIVE);
        for (int i = 0; i < this.itemControls.length; ++i) {
            int groupIdx = this.myPage * 8 + i;
            int groupCount = itemContainer.groupCount();
            if (groupCount <= groupIdx) continue;
            SolUiControl itemCtrl = this.itemControls[i];
            List<SolItem> group = itemContainer.getGroup(groupIdx);
            SolItem item = group.get(0);
            TextureAtlas.AtlasRegion tex = item.getIcon(game);
            Rectangle rect = itemCtrl.getScreenArea();
            float rowCenterY = rect.y + rect.height / 2.0f;
            uiDrawer.draw(UiDrawer.whiteTexture, imgSz, imgSz, imgSz / 2.0f, imgSz / 2.0f, rect.x + imgColW / 2.0f, rowCenterY, 0.0f, item.getItemType().uiColor);
            uiDrawer.draw((TextureRegion)tex, imgSz, imgSz, imgSz / 2.0f, imgSz / 2.0f, rect.x + imgColW / 2.0f, rowCenterY, 0.0f, SolColor.WHITE);
        }
    }

    @Override
    public void drawText(UiDrawer uiDrawer, SolApplication solApplication) {
        SolGame game = solApplication.getGame();
        ItemContainer itemContainer = this.myOperations.getItems(game);
        if (itemContainer == null) {
            itemContainer = EMPTY_CONTAINER;
        }
        float imgColW = this.myListArea.width * 0.1f;
        float equiColW = this.myListArea.width * 0.1f;
        float priceWidth = this.myListArea.width * 0.1f;
        float amtWidth = this.myListArea.width * 0.1f;
        float nameWidth = this.myListArea.width - imgColW - equiColW - priceWidth - amtWidth;
        for (int i = 0; i < this.itemControls.length; ++i) {
            float mul;
            int groupIdx = this.myPage * 8 + i;
            int groupCount = itemContainer.groupCount();
            if (groupCount <= groupIdx) continue;
            SolUiControl itemCtrl = this.itemControls[i];
            List<SolItem> group = itemContainer.getGroup(groupIdx);
            SolItem item = group.get(0);
            Rectangle rect = itemCtrl.getScreenArea();
            float rowCenterY = rect.y + rect.height / 2.0f;
            if (this.myOperations.isUsing(game, item)) {
                uiDrawer.drawString("using", rect.x + imgColW + equiColW / 2.0f, rowCenterY, 0.7f, true, SolColor.WHITE);
            }
            uiDrawer.drawString(item.getDisplayName(), rect.x + equiColW + imgColW + nameWidth / 2.0f, rowCenterY, 0.7f, true, this.mySelected == group ? SolColor.WHITE : SolColor.G);
            int count = itemContainer.getCount(groupIdx);
            if (count > 1) {
                uiDrawer.drawString("x" + count, rect.x + rect.width - amtWidth / 2.0f, rowCenterY, 0.7f, true, SolColor.WHITE);
            }
            if (!((mul = this.myOperations.getPriceMul()) > 0.0f)) continue;
            float price = item.getPrice() * mul;
            uiDrawer.drawString("$" + (int)price, rect.x + rect.width - amtWidth - priceWidth / 2.0f, rowCenterY, 0.7f, true, SolColor.LG);
        }
        uiDrawer.drawString(this.myOperations.getHeader(), this.myListHeaderPos.x, this.myListHeaderPos.y, 0.7f, UiDrawer.TextAlignment.LEFT, false, SolColor.WHITE);
        uiDrawer.drawString("Selected Item:", this.myDetailHeaderPos.x, this.myDetailHeaderPos.y, 0.7f, UiDrawer.TextAlignment.LEFT, false, SolColor.WHITE);
        if (this.mySelected != null && !this.mySelected.isEmpty()) {
            SolItem selItem = this.mySelected.get(0);
            String desc = selItem.getDisplayName() + "\n" + selItem.getDescription();
            uiDrawer.drawString(desc, this.myDetailArea.x + 0.015f, this.myDetailArea.y + 0.015f, 0.7f, UiDrawer.TextAlignment.LEFT, false, SolColor.WHITE);
        }
    }

    @Override
    public boolean reactsToClickOutside() {
        return true;
    }

    @Override
    public void blurCustom(SolApplication solApplication) {
        if (!this.showingHeroItems(solApplication)) {
            return;
        }
        SolGame game = solApplication.getGame();
        ItemContainer items = this.myOperations.getItems(game);
        if (items != null) {
            items.markAllAsSeen();
        }
    }

    private boolean showingHeroItems(SolApplication application) {
        return application.getGame().getHero().getShip() == this.showInventory.getTarget() || this.myOperations == this.sellItems;
    }

    public Rectangle itemCtrl(int row) {
        float h = (this.myItemCtrlArea.height - 0.012f) / 4.0f;
        return new Rectangle(this.myItemCtrlArea.x, this.myItemCtrlArea.y + (h + 0.004f) * (float)row, this.myItemCtrlArea.width, h);
    }

    public List<SolItem> getSelected() {
        return this.mySelected;
    }

    public void setSelected(List<SolItem> selected) {
        this.mySelected = selected;
    }

    public SolItem getSelectedItem() {
        return this.mySelected == null || this.mySelected.isEmpty() ? null : this.mySelected.get(0);
    }

    public InventoryOperationsScreen getOperations() {
        return this.myOperations;
    }

    public void setOperations(InventoryOperationsScreen operations) {
        this.myOperations = operations;
    }

    public int getPage() {
        return this.myPage;
    }

    public List<SolUiControl> getEquippedItemUIControlsForTutorial(SolGame game) {
        ArrayList<SolUiControl> controls = new ArrayList<SolUiControl>();
        ItemContainer itemContainer = this.myOperations.getItems(game);
        if (itemContainer == null) {
            return controls;
        }
        for (int i = 0; i < this.itemControls.length; ++i) {
            int groupIdx = this.myPage * 8 + i;
            int groupCount = itemContainer.groupCount();
            if (groupCount <= groupIdx) continue;
            SolUiControl itemCtrl = this.itemControls[i];
            List<SolItem> group = itemContainer.getGroup(groupIdx);
            SolItem item = group.get(0);
            if (!this.myOperations.isUsing(game, item)) continue;
            controls.add(itemCtrl);
        }
        return controls;
    }
}

